/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.extension.feature;

import com.github.dandelion.core.util.StringUtils;
import com.github.dandelion.datatables.core.extension.AbstractExtension;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.option.DatatableOptions;

public class ExternalFilterFeature
extends AbstractExtension {
    public static final String FEATURE_NAME = "externalFilter";

    @Override
    public String getExtensionName() {
        return FEATURE_NAME;
    }

    @Override
    public void setup(HtmlTable table) {
        String filterSelector = (String)DatatableOptions.FEATURE_FILTER_SELECTOR.valueFrom(table.getTableConfiguration().getOptions());
        String filterClearSelector = (String)DatatableOptions.FEATURE_FILTER_CLEAR_SELECTOR.valueFrom(table.getTableConfiguration().getOptions());
        StringBuilder js = new StringBuilder();
        js.append("$('").append(filterSelector).append("').click(function() {");
        js.append("   yadcf.exFilterExternallyTriggered(oTable_").append(table.getId()).append(");");
        js.append("});");
        this.appendToBeforeEndDocumentReady(js.toString());
        if (StringUtils.isNotBlank((String)filterClearSelector)) {
            js = new StringBuilder();
            js.append("$('").append(filterClearSelector).append("').click(function() {");
            js.append("   yadcf.exResetAllFilters(oTable_").append(table.getId()).append(");");
            js.append("});");
            this.appendToBeforeEndDocumentReady(js.toString());
        }
    }
}

