/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.extension.feature;

import com.github.dandelion.core.util.StringUtils;
import com.github.dandelion.datatables.core.DatatableBundles;
import com.github.dandelion.datatables.core.export.ExportConf;
import com.github.dandelion.datatables.core.export.HttpMethod;
import com.github.dandelion.datatables.core.extension.AbstractExtension;
import com.github.dandelion.datatables.core.extension.Parameter;
import com.github.dandelion.datatables.core.extension.feature.ExtraHtml;
import com.github.dandelion.datatables.core.html.HtmlHyperlink;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.option.DatatableOptions;

public class ExportFeature
extends AbstractExtension {
    public static final String EXTENSION_NAME = "export";
    private static final String TOOLBAR_PREXIX = "fg-toolbar ui-toolbar ui-widget-header ui-helper-clearfix ui-corner-";
    private HtmlTable table;

    @Override
    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    @Override
    public void setup(HtmlTable table) {
        this.table = table;
        for (ExportConf exportConf : table.getTableConfiguration().getExportConfigurations().values()) {
            if (!exportConf.getMethod().equals((Object)HttpMethod.POST) && !exportConf.getMethod().equals((Object)HttpMethod.PUT) && !exportConf.getMethod().equals((Object)HttpMethod.DELETE)) continue;
            this.addBundle(DatatableBundles.JQUERY_DOWNLOAD);
        }
        String exportContainerStyle = (String)DatatableOptions.EXPORT_CONTAINER_STYLE.valueFrom(table.getTableConfiguration().getOptions());
        String exportContainerClass = (String)DatatableOptions.EXPORT_CONTAINER_CLASS.valueFrom(table.getTableConfiguration().getOptions());
        ExtraHtml extraHtml = new ExtraHtml();
        extraHtml.setUid("E");
        extraHtml.setContainer("div");
        extraHtml.setCssClass("dataTables_export " + (StringUtils.isNotBlank((String)exportContainerClass) ? exportContainerClass : ""));
        extraHtml.setCssStyle(StringUtils.isNotBlank((String)exportContainerStyle) ? exportContainerStyle : "float: right;");
        String dom = (String)DatatableOptions.FEATURE_DOM.valueFrom(table.getTableConfiguration().getOptions());
        if (table.getTableConfiguration().getOptions().containsKey(DatatableOptions.CSS_THEME) && table.getTableConfiguration().getOptions().get(DatatableOptions.CSS_THEME).getClass().getSimpleName().equals("JQueryUITheme")) {
            this.addParameter("dom", "<'fg-toolbar ui-toolbar ui-widget-header ui-helper-clearfix ui-corner--tr'lEfr>t<'fg-toolbar ui-toolbar ui-widget-header ui-helper-clearfix ui-corner--br'ip>", Parameter.Mode.OVERRIDE);
        } else if (StringUtils.isBlank((String)dom)) {
            this.addParameter("dom", "lEfrtip", Parameter.Mode.OVERRIDE);
        }
        StringBuilder content = new StringBuilder();
        HtmlHyperlink link = null;
        for (ExportConf conf : table.getTableConfiguration().getExportConfigurations().values()) {
            link = new HtmlHyperlink();
            if (conf.getCssClass() != null) {
                link.setCssClass(conf.getCssClass());
            }
            if (conf.getCssStyle() != null) {
                link.setCssStyle(conf.getCssStyle());
                link.addCssStyle(";margin-left:2px;");
            } else {
                link.addCssStyle("margin-left:2px;");
            }
            if (conf.hasCustomUrl().booleanValue()) {
                link.setOnclick(this.getOnclick(conf));
            } else {
                link.setHref(conf.getUrl());
            }
            link.addContent(conf.getLabel());
            content.append((CharSequence)link.toHtml());
        }
        extraHtml.setContent(content.toString());
        this.appendToAfterStartDocumentReady(extraHtml.getJavascript().toString());
    }

    private String getOnclick(ExportConf exportConf) {
        String oTableId = "oTable_" + this.table.getId();
        StringBuilder params = new StringBuilder();
        StringBuilder exportFuncName = new StringBuilder("ddl_dt_launch_export_");
        exportFuncName.append(this.table.getId());
        exportFuncName.append("_");
        exportFuncName.append(exportConf.getFormat());
        StringBuilder exportFunc = new StringBuilder("function ");
        exportFunc.append(exportFuncName.toString());
        exportFunc.append("(){");
        params.append(oTableId).append(".ajax.params()");
        if (exportConf.getMethod().equals((Object)HttpMethod.GET)) {
            exportFunc.append("window.location=\"").append(exportConf.getUrl());
            if (exportConf.getUrl().contains("?")) {
                exportFunc.append("&");
            } else {
                exportFunc.append("?");
            }
            exportFunc.append("\" + decodeURIComponent($.param(").append(params.toString()).append(")).replace(/\\+/g,' ');");
        } else {
            exportFunc.append("$.download('").append(exportConf.getUrl()).append("', decodeURIComponent($.param(").append(params.toString()).append(")).replace(/\\+/g,' '),'").append((Object)exportConf.getMethod()).append("');");
        }
        exportFunc.append("}");
        this.appendToBeforeAll(exportFunc.toString());
        return exportFuncName.append("();").toString();
    }
}

