/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.extension.feature;

import com.github.dandelion.core.util.StringUtils;
import com.github.dandelion.datatables.core.extension.AbstractExtension;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.option.DatatableOptions;

public class AjaxReloadFeature
extends AbstractExtension {
    public static final String AJAX_RELOAD_FEATURE_NAME = "ajaxReload";

    @Override
    public String getExtensionName() {
        return AJAX_RELOAD_FEATURE_NAME;
    }

    @Override
    public void setup(HtmlTable table) {
        String reloadSelector = (String)DatatableOptions.AJAX_RELOAD_SELECTOR.valueFrom(table.getTableConfiguration().getOptions());
        String reloadFunction = (String)DatatableOptions.AJAX_RELOAD_FUNCTION.valueFrom(table.getTableConfiguration().getOptions());
        StringBuilder js = new StringBuilder();
        if (StringUtils.isNotBlank((String)reloadFunction)) {
            js.append("$('").append(reloadSelector).append("').bind('click', function() {");
            js.append(reloadFunction).append("();");
            js.append("});");
        } else {
            js.append("$('").append(reloadSelector).append("').bind('click', function() {");
            js.append("oTable_").append(table.getId()).append(".ajax.reload();");
            js.append("});");
        }
        this.appendToBeforeEndDocumentReady(js.toString());
    }
}

