/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.extension.feature;

import com.github.dandelion.core.DandelionException;
import com.github.dandelion.datatables.core.DatatableBundles;
import com.github.dandelion.datatables.core.extension.AbstractExtension;
import com.github.dandelion.datatables.core.extension.feature.FilterPlaceholder;
import com.github.dandelion.datatables.core.generator.YadcfConfigGenerator;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.option.DatatableOptions;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONValue;

public abstract class AbstractFilteringFeature
extends AbstractExtension {
    public static final String FILTERING_FEATURE_NAME = "filtering";

    @Override
    public String getExtensionName() {
        return FILTERING_FEATURE_NAME;
    }

    @Override
    public void setup(HtmlTable table) {
        this.addBundle(DatatableBundles.YADCF);
        FilterPlaceholder filterPlaceHolder = (FilterPlaceholder)((Object)DatatableOptions.FEATURE_FILTER_PLACEHOLDER.valueFrom(table.getTableConfiguration().getOptions()));
        if (filterPlaceHolder != null) {
            switch (filterPlaceHolder) {
                case FOOTER: {
                    this.adaptFooter(table);
                    break;
                }
                case HEADER: {
                    break;
                }
            }
        } else {
            filterPlaceHolder = FilterPlaceholder.FOOTER;
            this.adaptFooter(table);
        }
        YadcfConfigGenerator configGenerator = new YadcfConfigGenerator();
        List<Map<String, Object>> config = configGenerator.generateConfig(table);
        StringWriter writer = new StringWriter();
        try {
            JSONValue.writeJSONString(config, (Writer)writer);
        }
        catch (IOException e) {
            throw new DandelionException("Unable to convert the configuration to JSON", (Throwable)e);
        }
        StringBuilder yadcf = new StringBuilder("yadcf.init(oTable_");
        yadcf.append(table.getId());
        yadcf.append(",");
        yadcf.append(((Object)writer).toString());
        if (filterPlaceHolder != null) {
            yadcf.append(", '");
            yadcf.append(filterPlaceHolder.getName());
            yadcf.append("'");
        }
        yadcf.append(");");
        this.appendToBeforeEndDocumentReady(yadcf.toString());
    }

    protected abstract void adaptHeader(HtmlTable var1);

    protected abstract void adaptFooter(HtmlTable var1);
}

