/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.extension;

import com.github.dandelion.core.asset.generator.js.JsFunction;
import com.github.dandelion.core.asset.generator.js.JsSnippet;
import com.github.dandelion.datatables.core.extension.Extension;
import com.github.dandelion.datatables.core.extension.Parameter;
import com.github.dandelion.datatables.core.generator.DatatableJQueryContent;
import com.github.dandelion.datatables.core.html.HtmlTable;
import java.util.Collection;
import java.util.Map;

public class ExtensionProcessor {
    private final HtmlTable table;
    private final DatatableJQueryContent datatableContent;
    private final Map<String, Object> mainConfig;

    public ExtensionProcessor(HtmlTable table, DatatableJQueryContent datatableContent, Map<String, Object> mainConfig) {
        this.table = table;
        this.datatableContent = datatableContent;
        this.mainConfig = mainConfig;
    }

    public void process(Collection<Extension> extensions) {
        if (extensions != null && !extensions.isEmpty()) {
            for (Extension extension : extensions) {
                this.process(extension);
            }
        }
    }

    public void process(Extension extension) {
        if (extension != null) {
            extension.setupWrapper(this.table);
            this.injectIntoMainJsFile(extension);
            this.injectIntoMainConfiguration(extension);
        }
    }

    private void injectIntoMainJsFile(Extension extension) {
        if (extension.getBeforeAll() != null) {
            this.datatableContent.appendToBeforeAll(extension.getBeforeAll().toString());
        }
        if (extension.getBeforeStartDocumentReady() != null) {
            this.datatableContent.appendToBeforeStartDocumentReady(extension.getBeforeStartDocumentReady().toString());
        }
        if (extension.getAfterStartDocumentReady() != null) {
            this.datatableContent.appendToAfterStartDocumentReady(extension.getAfterStartDocumentReady().toString());
        }
        if (extension.getBeforeEndDocumentReady() != null) {
            this.datatableContent.appendToBeforeEndDocumentReady(extension.getBeforeEndDocumentReady().toString());
        }
        if (extension.getAfterAll() != null) {
            this.datatableContent.appendToAfterAll(extension.getAfterAll().toString());
        }
    }

    private void injectIntoMainConfiguration(Extension extension) {
        if (extension.getParameters() != null) {
            for (Parameter param : extension.getParameters()) {
                if (this.mainConfig.containsKey(param.getName())) {
                    if (this.mainConfig.get(param.getName()) instanceof JsFunction) {
                        this.processJsFunction(param);
                        continue;
                    }
                    if (this.mainConfig.get(param.getName()) instanceof JsSnippet) {
                        this.processJavascriptSnippet(param);
                        continue;
                    }
                    this.processString(param);
                    continue;
                }
                this.mainConfig.put(param.getName(), param.getValue());
            }
        }
    }

    private void processJsFunction(Parameter conf) {
        JsFunction jsFunction = (JsFunction)this.mainConfig.get(conf.getName());
        StringBuilder newValue = null;
        switch (conf.getMode()) {
            case OVERRIDE: {
                this.mainConfig.put(conf.getName(), conf.getValue());
                break;
            }
            case APPEND: {
                newValue = new StringBuilder(((JsFunction)conf.getValue()).getCode());
                newValue.append(jsFunction.getCode());
                jsFunction.setCode(newValue.toString());
                this.mainConfig.put(conf.getName(), jsFunction);
                break;
            }
            case PREPEND: {
                newValue = new StringBuilder(jsFunction.getCode());
                newValue.append(((JsFunction)conf.getValue()).getCode());
                jsFunction.setCode(newValue.toString());
                this.mainConfig.put(conf.getName(), jsFunction);
                break;
            }
            case APPEND_WITH_SPACE: {
                newValue = new StringBuilder(((JsFunction)conf.getValue()).getCode());
                newValue.append(" ");
                newValue.append(jsFunction.getCode());
                jsFunction.setCode(newValue.toString());
                this.mainConfig.put(conf.getName(), jsFunction);
                break;
            }
            case PREPEND_WITH_SPACE: {
                newValue = new StringBuilder(jsFunction.getCode());
                newValue.append(" ");
                newValue.append(((JsFunction)conf.getValue()).getCode());
                jsFunction.setCode(newValue.toString());
                this.mainConfig.put(conf.getName(), jsFunction);
                break;
            }
        }
    }

    private void processJavascriptSnippet(Parameter conf) {
        JsSnippet jsSnippet = (JsSnippet)this.mainConfig.get(conf.getName());
        String newValue = null;
        switch (conf.getMode()) {
            case OVERRIDE: {
                this.mainConfig.put(conf.getName(), conf.getValue());
                break;
            }
            case APPEND: {
                newValue = ((JsSnippet)conf.getValue()).getJavascript() + jsSnippet.getJavascript();
                jsSnippet.setJavascript(newValue);
                this.mainConfig.put(conf.getName(), jsSnippet);
                break;
            }
            case PREPEND: {
                newValue = jsSnippet.getJavascript() + ((JsSnippet)conf.getValue()).getJavascript();
                jsSnippet.setJavascript(newValue);
                this.mainConfig.put(conf.getName(), jsSnippet);
                break;
            }
            case APPEND_WITH_SPACE: {
                newValue = ((JsSnippet)conf.getValue()).getJavascript() + " " + jsSnippet.getJavascript();
                jsSnippet.setJavascript(newValue);
                this.mainConfig.put(conf.getName(), jsSnippet);
                break;
            }
            case PREPEND_WITH_SPACE: {
                newValue = jsSnippet.getJavascript() + " " + ((JsSnippet)conf.getValue()).getJavascript();
                jsSnippet.setJavascript(newValue);
                this.mainConfig.put(conf.getName(), jsSnippet);
                break;
            }
        }
    }

    private void processString(Parameter conf) {
        String value = null;
        switch (conf.getMode()) {
            case OVERRIDE: {
                this.mainConfig.put(conf.getName(), conf.getValue());
                break;
            }
            case APPEND: {
                value = (String)this.mainConfig.get(conf.getName());
                value = value + conf.getValue();
                this.mainConfig.put(conf.getName(), value);
                break;
            }
            case PREPEND: {
                value = (String)this.mainConfig.get(conf.getName());
                value = conf.getValue() + value;
                this.mainConfig.put(conf.getName(), value);
                break;
            }
            case APPEND_WITH_SPACE: {
                value = (String)this.mainConfig.get(conf.getName());
                value = value + " " + conf.getValue();
                this.mainConfig.put(conf.getName(), value);
                break;
            }
            case PREPEND_WITH_SPACE: {
                value = (String)this.mainConfig.get(conf.getName());
                value = conf.getValue() + " " + value;
                this.mainConfig.put(conf.getName(), value);
                break;
            }
        }
    }
}

