/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.extension;

import com.github.dandelion.core.DandelionException;
import com.github.dandelion.core.util.ServiceLoaderUtils;
import com.github.dandelion.core.util.Validate;
import com.github.dandelion.datatables.core.extension.Extension;
import com.github.dandelion.datatables.core.extension.ExtensionProcessor;
import com.github.dandelion.datatables.core.generator.DatatableJQueryContent;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.option.DatatableOptions;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionLoader {
    private static Logger logger = LoggerFactory.getLogger(ExtensionLoader.class);

    public void loadExtensions(HtmlTable table, DatatableJQueryContent datatableContent, Map<String, Object> mainConf) {
        this.registerExtensions(table);
        ExtensionProcessor extensionProcessor = new ExtensionProcessor(table, datatableContent, mainConf);
        extensionProcessor.process(table.getTableConfiguration().getInternalExtensions());
        Extension theme = (Extension)DatatableOptions.CSS_THEME.valueFrom(table.getTableConfiguration().getOptions());
        if (theme != null) {
            extensionProcessor.process(new HashSet<Extension>(Arrays.asList(theme)));
        }
    }

    public static Extension get(String extensionName) {
        Validate.notBlank((String)extensionName, (String)"The extension name can't be blank");
        ServiceLoader<Extension> loadedExtensions = ServiceLoader.load(Extension.class);
        for (Extension ex : loadedExtensions) {
            if (!ex.getExtensionName().equalsIgnoreCase(extensionName)) continue;
            return ex;
        }
        throw new DandelionException("The requested extension \"" + extensionName + "\" is not present in the classpath.");
    }

    private void registerExtensions(HtmlTable table) {
        logger.debug("Scanning for extensions...");
        List builtInExtensions = ServiceLoaderUtils.getProvidersAsList(Extension.class);
        Set extensionNames = (Set)DatatableOptions.MAIN_EXTENSION_NAMES.valueFrom(table.getTableConfiguration().getOptions());
        if (builtInExtensions != null && !builtInExtensions.isEmpty() && extensionNames != null && !extensionNames.isEmpty()) {
            for (String extensionToRegister : extensionNames) {
                for (Extension extension : builtInExtensions) {
                    if (!extensionToRegister.equalsIgnoreCase(extension.getExtensionName())) continue;
                    table.getTableConfiguration().registerExtension(extension);
                    logger.debug("Extension '{}' registered in table '{}'", (Object)extension.getExtensionName(), (Object)table.getId());
                }
            }
        }
    }
}

