/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.export;

import com.github.dandelion.core.DandelionException;
import com.github.dandelion.core.util.ClassUtils;
import com.github.dandelion.datatables.core.export.DatatablesExport;
import com.github.dandelion.datatables.core.export.ExportConf;
import com.github.dandelion.datatables.core.html.HtmlTable;
import java.io.ByteArrayOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportDelegate {
    private static Logger logger = LoggerFactory.getLogger(ExportDelegate.class);
    private HtmlTable htmlTable;
    private HttpServletRequest request;

    public ExportDelegate(HtmlTable htmlTable, HttpServletRequest request) {
        this.htmlTable = htmlTable;
        this.request = request;
    }

    public void prepareExport() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        String exportFormat = this.htmlTable.getTableConfiguration().getCurrentExportFormat();
        ExportConf exportConf = this.htmlTable.getTableConfiguration().getExportConfigurations().get(exportFormat);
        String exportClassName = exportConf.getExportClass();
        if (exportClassName == null) {
            throw new DandelionException("No export class has been configured for the '" + exportFormat + "' format. Please configure it before exporting.");
        }
        logger.debug("Selected export class: {}", (Object)exportClassName);
        if (!ClassUtils.isPresent((String)exportClassName)) {
            StringBuilder sb = new StringBuilder("Unable to export in the ");
            sb.append(exportFormat);
            sb.append(" format because either the export class '");
            sb.append(exportClassName);
            sb.append("' or some other librairies ");
            sb.append(" imported in the export class is not present in the classpath.");
            sb.append("Did you forget to add a dependency?");
            throw new DandelionException(sb.toString());
        }
        Class exportClass = null;
        Object obj = null;
        try {
            exportClass = ClassUtils.getClass((String)exportClassName);
            obj = ClassUtils.getNewInstance((Class)exportClass);
        }
        catch (ClassNotFoundException e) {
            throw new DandelionException("Unable to load the class '" + exportClassName + "'", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new DandelionException("Unable to instanciate the class '" + exportClassName + "'", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new DandelionException("Unable to access the class '" + exportClassName + "'", (Throwable)e);
        }
        ((DatatablesExport)obj).initExport(this.htmlTable);
        ((DatatablesExport)obj).processExport(stream);
        this.request.setAttribute("ddl-dt-export-content", (Object)stream.toByteArray());
        this.request.setAttribute("ddl-dt-export-conf", (Object)exportConf);
    }
}

