/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.export;

import com.github.dandelion.core.DandelionException;
import com.github.dandelion.datatables.core.export.DatatablesExport;
import com.github.dandelion.datatables.core.export.ExportConf;
import com.github.dandelion.datatables.core.html.HtmlColumn;
import com.github.dandelion.datatables.core.html.HtmlRow;
import com.github.dandelion.datatables.core.html.HtmlTable;
import java.io.IOException;
import java.io.OutputStream;

public class CsvExport
implements DatatablesExport {
    private static final String SEPARATOR_CHAR = ";";
    private HtmlTable table;
    private ExportConf exportConf;

    @Override
    public void initExport(HtmlTable table) {
        this.table = table;
        this.exportConf = table.getTableConfiguration().getExportConfigurations().get("csv");
    }

    @Override
    public void processExport(OutputStream output) {
        StringBuilder buffer = new StringBuilder();
        if (this.exportConf.getIncludeHeader().booleanValue()) {
            for (HtmlRow row : this.table.getHeadRows()) {
                for (HtmlColumn column : row.getColumns("all", "csv")) {
                    buffer.append((CharSequence)column.getContent()).append(SEPARATOR_CHAR);
                }
                buffer.append("\n");
            }
        }
        for (HtmlRow row : this.table.getBodyRows()) {
            for (HtmlColumn column : row.getColumns("all", "csv")) {
                buffer.append((CharSequence)column.getContent()).append(SEPARATOR_CHAR);
            }
            buffer.append("\n");
        }
        try {
            output.write(buffer.toString().getBytes());
        }
        catch (IOException e) {
            StringBuilder sb = new StringBuilder("Something went wrong during the CSV generation of the table '");
            sb.append(this.table.getOriginalId());
            sb.append("' and with the following export configuration: ");
            sb.append(this.exportConf.toString());
            throw new DandelionException(sb.toString(), (Throwable)e);
        }
    }
}

