/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.config;

import com.github.dandelion.core.DandelionException;
import com.github.dandelion.core.i18n.LocaleResolver;
import com.github.dandelion.core.i18n.MessageResolver;
import com.github.dandelion.core.util.ClassUtils;
import com.github.dandelion.datatables.core.config.ConfigLoader;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatatableConfigurator {
    private static Logger logger = LoggerFactory.getLogger(DatatableConfigurator.class);
    private static LocaleResolver localeResolver;
    private static MessageResolver messageResolver;

    public static LocaleResolver getLocaleResolver() {
        block9: {
            Properties userProperties = null;
            String className = null;
            ConfigLoader configurationLoader = DatatableConfigurator.getConfigLoader();
            if (localeResolver == null) {
                try {
                    userProperties = configurationLoader.loadUserConfiguration(Locale.getDefault());
                    if (userProperties != null) {
                        try {
                            className = userProperties.getProperty("i18n.locale.resolver");
                        }
                        catch (MissingResourceException e) {
                            logger.debug("No custom LocaleResolver has been configured. Using default one.");
                        }
                    }
                    if (className == null) {
                        Properties defaultProperties = configurationLoader.loadDefaultConfiguration();
                        className = defaultProperties.getProperty("i18n.locale.resolver");
                    }
                    if (className == null) break block9;
                    try {
                        Class classProperty = ClassUtils.getClass((String)className);
                        localeResolver = (LocaleResolver)ClassUtils.getNewInstance((Class)classProperty);
                    }
                    catch (Exception e) {
                        throw new DandelionException((Throwable)e);
                    }
                }
                catch (DandelionException e) {
                    throw new DandelionException("Unable to retrieve the LocaleResolver using the class '" + className + "'", (Throwable)e);
                }
            }
        }
        return localeResolver;
    }

    public static MessageResolver getMessageResolver(HttpServletRequest request) {
        block9: {
            Properties userProperties = null;
            String className = null;
            ConfigLoader configurationLoader = DatatableConfigurator.getConfigLoader();
            if (messageResolver == null) {
                try {
                    userProperties = configurationLoader.loadUserConfiguration(Locale.getDefault());
                    if (userProperties != null) {
                        try {
                            className = userProperties.getProperty("i18n.message.resolver");
                        }
                        catch (MissingResourceException e) {
                            logger.debug("No custom MessageResolver has been configured. Using default one.");
                        }
                    }
                    if (className == null) {
                        Properties defaultProperties = configurationLoader.loadDefaultConfiguration();
                        className = defaultProperties.getProperty("i18n.message.resolver");
                    }
                    if (className == null) break block9;
                    try {
                        Class classProperty = ClassUtils.getClass((String)className);
                        messageResolver = (MessageResolver)classProperty.getDeclaredConstructor(HttpServletRequest.class).newInstance(request);
                    }
                    catch (Exception e) {
                        throw new DandelionException((Throwable)e);
                    }
                }
                catch (DandelionException e) {
                    throw new DandelionException("Unable to retrieve the MessageResolver using the class '" + className + "'", (Throwable)e);
                }
            }
        }
        return messageResolver;
    }

    public static ConfigLoader getConfigLoader() {
        return ConfigLoaderHolder.INSTANCE;
    }

    public static void clear() {
        localeResolver = null;
    }

    private DatatableConfigurator() {
        throw new AssertionError();
    }

    private static class ConfigLoaderHolder {
        private static final ConfigLoader INSTANCE = new ConfigLoader();

        private ConfigLoaderHolder() {
        }
    }
}

