/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.config;

import com.github.dandelion.core.DandelionException;
import com.github.dandelion.core.option.Option;
import com.github.dandelion.core.util.LibraryDetector;
import com.github.dandelion.core.util.PropertiesUtils;
import com.github.dandelion.core.util.StringUtils;
import com.github.dandelion.core.util.UTF8Control;
import com.github.dandelion.core.web.AssetRequestContext;
import com.github.dandelion.datatables.core.option.DatatableOptions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigLoader {
    private static Logger logger = LoggerFactory.getLogger(ConfigLoader.class);
    public static final String DANDELION_DT_CONFIGURATION = "dandelion.datatables.configuration";
    public static final String DT_DEFAULT_PROPERTIES = "config/datatables-default.properties";
    public static final String DT_USER_PROPERTIES_LOCATION = "dandelion/datatables/";
    public static final String DT_USER_PROPERTIES = "datatables";
    public static final String DEFAULT_GROUP_NAME = "global";
    public static final String STANDALONE_BUNDLES_TO_EXCLUDE = "bootstrap-datepicker,bootstrap2,bootstrap3,jquery,jqueryui,moment";
    public static final String I18N_LOCALE_RESOLVER = "i18n.locale.resolver";
    public static final String I18N_MESSAGE_RESOLVER = "i18n.message.resolver";
    private static Properties defaultProperties;
    private Properties userProperties;
    private Set<String> groups;

    public Properties loadDefaultConfiguration() {
        if (defaultProperties == null) {
            logger.debug("Loading default configuration...");
            Properties propertiesResource = new Properties();
            InputStream propertiesStream = null;
            try {
                propertiesStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(DT_DEFAULT_PROPERTIES);
                InputStreamReader reader = new InputStreamReader(propertiesStream, "UTF-8");
                propertiesResource.load(reader);
            }
            catch (IOException e) {
                throw new DandelionException("Unable to load the default configuration file", (Throwable)e);
            }
            finally {
                if (propertiesStream != null) {
                    try {
                        propertiesStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            defaultProperties = propertiesResource;
            logger.debug("Default configuration loaded");
        }
        return defaultProperties;
    }

    public Properties loadUserConfiguration(Locale locale) {
        ResourceBundle.clearCache();
        ResourceBundle userBundle = null;
        if (StringUtils.isNotBlank((String)System.getProperty(DANDELION_DT_CONFIGURATION))) {
            String path = System.getProperty(DANDELION_DT_CONFIGURATION);
            try {
                URL resourceURL = new File(path).toURI().toURL();
                URLClassLoader urlLoader = new URLClassLoader(new URL[]{resourceURL});
                userBundle = ResourceBundle.getBundle(DT_USER_PROPERTIES, locale, urlLoader, (ResourceBundle.Control)new UTF8Control());
            }
            catch (MalformedURLException e) {
                logger.warn("Wrong path to the externalized bundle", (Throwable)e);
            }
            catch (MissingResourceException e) {
                logger.info("No *.properties file in {}. Trying to lookup in classpath...", (Object)path);
            }
        }
        if (userBundle == null) {
            try {
                userBundle = ResourceBundle.getBundle("dandelion/datatables/datatables", locale, (ResourceBundle.Control)new UTF8Control());
            }
            catch (MissingResourceException e) {
                try {
                    userBundle = ResourceBundle.getBundle("dandelion/datatables/datatables", locale, Thread.currentThread().getContextClassLoader(), (ResourceBundle.Control)new UTF8Control());
                }
                catch (MissingResourceException mre) {
                    logger.debug("No custom configuration. Using default one.");
                }
            }
        }
        this.userProperties = PropertiesUtils.bundleToProperties(userBundle);
        return this.userProperties;
    }

    public Set<String> resolveGroups(Locale locale) {
        logger.debug("Resolving groups for the locale {}...", (Object)locale);
        HashSet<String> groups = new HashSet<String>();
        if (this.userProperties != null && !this.userProperties.isEmpty()) {
            for (Map.Entry<Object, Object> entry : this.userProperties.entrySet()) {
                String key = entry.getKey().toString();
                if (key.contains(I18N_LOCALE_RESOLVER) || key.contains(I18N_MESSAGE_RESOLVER) || key.contains("main.standalone")) continue;
                groups.add(key.substring(0, key.indexOf(".")));
            }
        }
        groups.add(DEFAULT_GROUP_NAME);
        logger.debug("{} groups declared {}.", (Object)groups.size(), (Object)((Object)groups).toString());
        this.groups = groups;
        return this.groups;
    }

    public void resolveConfigurations(Map<String, Map<Option<?>, Object>> map, Locale locale, HttpServletRequest request) {
        String key;
        logger.debug("Resolving configurations for the locale {}...", (Object)locale);
        this.loadAutoConfiguration(this.userProperties);
        Properties globalProperties = new Properties();
        for (Map.Entry<Object, Object> entry : defaultProperties.entrySet()) {
            key = entry.getKey().toString();
            if (key.equalsIgnoreCase(I18N_LOCALE_RESOLVER) || key.equalsIgnoreCase(I18N_MESSAGE_RESOLVER) || key.equalsIgnoreCase("main.standalone")) continue;
            globalProperties.put(key.substring(key.indexOf(".") + 1), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : this.userProperties.entrySet()) {
            key = entry.getKey().toString();
            if (!key.startsWith(DEFAULT_GROUP_NAME)) continue;
            globalProperties.put(key.substring(key.indexOf(".") + 1), entry.getValue());
        }
        if (this.userProperties.containsKey("main.standalone") && this.userProperties.getProperty("main.standalone").equals("true")) {
            AssetRequestContext.get((ServletRequest)request).excludeBundles(STANDALONE_BUNDLES_TO_EXCLUDE);
        }
        HashMap userConf = null;
        ConcurrentHashMap wrongKeys = new ConcurrentHashMap();
        for (String groupName : this.groups) {
            String key2;
            Properties groupedProperties = new Properties();
            groupedProperties.putAll((Map<?, ?>)globalProperties);
            for (Map.Entry<Object, Object> entry : this.userProperties.entrySet()) {
                key2 = entry.getKey().toString();
                if (!key2.startsWith(groupName)) continue;
                groupedProperties.put(key2.substring(key2.indexOf(".") + 1), entry.getValue());
            }
            logger.debug("Group '{}' initialized with {} properties", (Object)groupName, (Object)groupedProperties.size());
            userConf = new HashMap();
            for (Map.Entry<Object, Object> entry : groupedProperties.entrySet()) {
                key2 = entry.getKey().toString().trim().toLowerCase();
                Option<?> config = DatatableOptions.findByName(key2);
                if (config != null) {
                    userConf.put(config, entry.getValue().toString());
                    continue;
                }
                if (key2.equals(I18N_LOCALE_RESOLVER) || key2.equals(I18N_MESSAGE_RESOLVER)) continue;
                if (wrongKeys.containsKey(groupName)) {
                    ((List)wrongKeys.get(groupName)).add(key2);
                    continue;
                }
                ArrayList<String> values = new ArrayList<String>();
                values.add(key2);
                wrongKeys.put(groupName, values);
            }
            map.put(groupName, userConf);
        }
        if (!wrongKeys.isEmpty()) {
            StringBuilder msg = new StringBuilder("Some properties of your configuration file are not recognized.\n");
            for (Map.Entry entry : wrongKeys.entrySet()) {
                msg.append("The group '");
                msg.append((String)entry.getKey());
                msg.append("' contains ");
                msg.append(((List)entry.getValue()).size());
                msg.append(" unknown propert");
                msg.append(((List)entry.getValue()).size() > 1 ? "ies:\n" : "y:\n");
                for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                    msg.append((String)((List)entry.getValue()).get(i));
                    if (i >= ((List)entry.getValue()).size() - 1) continue;
                    msg.append("\n");
                }
                msg.append("\n");
            }
            logger.error(msg.toString());
            throw new DandelionException(msg.toString());
        }
        logger.debug("{} group(s) resolved {} for the locale {}", new Object[]{this.groups.size(), this.groups.toString(), locale});
    }

    public Properties getUserProperties() {
        return this.userProperties;
    }

    private void loadAutoConfiguration(Properties userProps) {
        if (LibraryDetector.isJstlAvailable() && !LibraryDetector.isThymeleafAvailable() && userProps != null) {
            if (!userProps.isEmpty()) {
                for (Map.Entry<Object, Object> entry : userProps.entrySet()) {
                    String key = entry.getKey().toString();
                    if (!key.contains(I18N_MESSAGE_RESOLVER) || !StringUtils.isBlank((String)entry.getValue().toString())) continue;
                    userProps.put(entry.getKey(), "com.github.dandelion.datatables.jsp.i18n.JstlMessageResolver");
                }
            } else {
                userProps.put("global.i18n.message.resolver", "com.github.dandelion.datatables.jsp.i18n.JstlMessageResolver");
            }
        }
    }
}

