/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.ajax;

import com.github.dandelion.datatables.core.ajax.DataSet;
import com.github.dandelion.datatables.core.ajax.DatatablesCriterias;
import java.util.List;

public class DatatablesResponse<T> {
    private final List<T> data;
    private final Long recordsTotal;
    private final Long recordsFiltered;
    private final Integer draw;

    private DatatablesResponse(DataSet<T> dataSet, DatatablesCriterias criterias) {
        this.data = dataSet.getRows();
        this.recordsTotal = dataSet.getTotalRecords();
        this.recordsFiltered = dataSet.getTotalDisplayRecords();
        this.draw = criterias.getDraw();
    }

    public List<T> getData() {
        return this.data;
    }

    public Long getRecordsTotal() {
        return this.recordsTotal;
    }

    public Long getRecordsFiltered() {
        return this.recordsFiltered;
    }

    public Integer getDraw() {
        return this.draw;
    }

    public static <T> DatatablesResponse<T> build(DataSet<T> dataSet, DatatablesCriterias criterias) {
        return new DatatablesResponse<T>(dataSet, criterias);
    }
}

