/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.ajax;

import com.github.dandelion.core.util.StringUtils;
import com.github.dandelion.core.util.Validate;
import com.github.dandelion.datatables.core.ajax.ColumnDef;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatatablesCriterias
implements Serializable {
    private static final long serialVersionUID = 8661357461501153387L;
    private static final Logger LOG = LoggerFactory.getLogger(DatatablesCriterias.class);
    private static Pattern pattern = Pattern.compile("columns\\[([0-9]*)?\\]");
    private final String search;
    private final Integer start;
    private final Integer length;
    private final List<ColumnDef> columnDefs;
    private final List<ColumnDef> sortedColumnDefs;
    private final Integer draw;

    private DatatablesCriterias(String search, Integer displayStart, Integer displaySize, List<ColumnDef> columnDefs, List<ColumnDef> sortedColumnDefs, Integer draw) {
        this.search = search;
        this.start = displayStart;
        this.length = displaySize;
        this.columnDefs = columnDefs;
        this.sortedColumnDefs = sortedColumnDefs;
        this.draw = draw;
    }

    public Integer getStart() {
        return this.start;
    }

    public Integer getLength() {
        return this.length;
    }

    public String getSearch() {
        return this.search;
    }

    public Integer getDraw() {
        return this.draw;
    }

    public List<ColumnDef> getColumnDefs() {
        return this.columnDefs;
    }

    public List<ColumnDef> getSortingColumnDefs() {
        return this.sortedColumnDefs;
    }

    public List<ColumnDef> getSortedColumnDefs() {
        return this.sortedColumnDefs;
    }

    public Boolean hasOneFilterableColumn() {
        return this.hasOneSearchableColumn();
    }

    public Boolean hasOneSearchableColumn() {
        for (ColumnDef columnDef : this.columnDefs) {
            if (!columnDef.isSearchable()) continue;
            return true;
        }
        return false;
    }

    public Boolean hasOneFilteredColumn() {
        for (ColumnDef columnDef : this.columnDefs) {
            if (!StringUtils.isNotBlank((String)columnDef.getSearch()) && !StringUtils.isNotBlank((String)columnDef.getSearchFrom()) && !StringUtils.isNotBlank((String)columnDef.getSearchTo())) continue;
            return true;
        }
        return false;
    }

    public Boolean hasOneSortedColumn() {
        return !this.sortedColumnDefs.isEmpty();
    }

    public static DatatablesCriterias getFromRequest(HttpServletRequest request) {
        Validate.notNull((Object)request, (String)"The HTTP request cannot be null");
        int columnNumber = DatatablesCriterias.getColumnNumber(request);
        LOG.trace("Number of columns: {}", (Object)columnNumber);
        String paramSearch = request.getParameter("search[value]");
        String paramDraw = request.getParameter("draw");
        String paramStart = request.getParameter("start");
        String paramLength = request.getParameter("length");
        Integer draw = StringUtils.isNotBlank((String)paramDraw) ? Integer.parseInt(paramDraw) : -1;
        Integer start = StringUtils.isNotBlank((String)paramStart) ? Integer.parseInt(paramStart) : -1;
        Integer length = StringUtils.isNotBlank((String)paramLength) ? Integer.parseInt(paramLength) : -1;
        ArrayList<ColumnDef> columnDefs = new ArrayList<ColumnDef>();
        for (int i = 0; i < columnNumber; ++i) {
            ColumnDef columnDef = new ColumnDef();
            columnDef.setName(request.getParameter("columns[" + i + "][data]"));
            columnDef.setSearchable(Boolean.parseBoolean(request.getParameter("columns[" + i + "][searchable]")));
            columnDef.setSortable(Boolean.parseBoolean(request.getParameter("columns[" + i + "][orderable]")));
            columnDef.setRegex(request.getParameter("columns[" + i + "][search][regex]"));
            String searchTerm = request.getParameter("columns[" + i + "][search][value]");
            if (StringUtils.isNotBlank((String)searchTerm)) {
                columnDef.setFiltered(true);
                String[] splittedSearch = searchTerm.split("~");
                if ("~".equals(searchTerm)) {
                    columnDef.setSearch("");
                } else if (searchTerm.startsWith("~")) {
                    columnDef.setSearchTo(splittedSearch[1]);
                } else if (searchTerm.endsWith("~")) {
                    columnDef.setSearchFrom(splittedSearch[0]);
                } else if (searchTerm.contains("~")) {
                    columnDef.setSearchFrom(splittedSearch[0]);
                    columnDef.setSearchTo(splittedSearch[1]);
                } else {
                    columnDef.setSearch(searchTerm);
                }
            }
            for (int j = 0; j < columnNumber; ++j) {
                String ordered = request.getParameter("order[" + j + "][column]");
                if (ordered == null || !ordered.equals(String.valueOf(i))) continue;
                columnDef.setSorted(true);
                break;
            }
            columnDefs.add(columnDef);
        }
        LinkedList<ColumnDef> sortedColumnDefs = new LinkedList<ColumnDef>();
        for (int i = 0; i < columnNumber; ++i) {
            String paramSortedCol = request.getParameter("order[" + i + "][column]");
            if (!StringUtils.isNotBlank((String)paramSortedCol)) continue;
            Integer sortedCol = Integer.parseInt(paramSortedCol);
            ColumnDef sortedColumnDef = (ColumnDef)columnDefs.get(sortedCol);
            String sortedColDirection = request.getParameter("order[" + i + "][dir]");
            if (StringUtils.isNotBlank((String)sortedColDirection)) {
                sortedColumnDef.setSortDirection(ColumnDef.SortDirection.valueOf(sortedColDirection.toUpperCase()));
            }
            sortedColumnDefs.add(sortedColumnDef);
        }
        return new DatatablesCriterias(paramSearch, start, length, columnDefs, sortedColumnDefs, draw);
    }

    private static int getColumnNumber(HttpServletRequest request) {
        int columnNumber = 0;
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String param = (String)e.nextElement();
            Matcher matcher = pattern.matcher(param);
            while (matcher.find()) {
                Integer col = Integer.parseInt(matcher.group(1));
                if (col <= columnNumber) continue;
                columnNumber = col;
            }
        }
        if (columnNumber != 0) {
            ++columnNumber;
        }
        return columnNumber;
    }

    public String toString() {
        return "DatatablesCriterias [search=" + this.search + ", start=" + this.start + ", length=" + this.length + ", columnDefs=" + this.columnDefs + ", sortingColumnDefs=" + this.sortedColumnDefs + ", draw=" + this.draw + "]";
    }
}

