/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.processor.export;

import com.github.dandelion.core.utils.StringUtils;
import com.github.dandelion.datatables.core.configuration.ConfigToken;
import com.github.dandelion.datatables.core.exception.ConfigurationProcessingException;
import com.github.dandelion.datatables.core.export.ExportConf;
import com.github.dandelion.datatables.core.processor.AbstractConfigurationProcessor;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportFormatProcessor
extends AbstractConfigurationProcessor {
    private static Logger logger = LoggerFactory.getLogger(ExportFormatProcessor.class);
    public static final String REGEX_EXPORT_CLASS = "export\\.(.*?)\\.class";
    public static final String REGEX_EXPORT_LABEL = "export\\.(.*?)\\.label";
    public static final String REGEX_EXPORT_FILENAME = "export\\.(.*?)\\.fileName";
    public static final String REGEX_EXPORT_MIMETYPE = "export\\.(.*?)\\.mimeType";
    private static final Pattern PATTERN_EXPORT_CLASS = Pattern.compile("export\\.(.*?)\\.class", 2);
    private static final Pattern PATTERN_EXPORT_LABEL = Pattern.compile("export\\.(.*?)\\.label", 2);
    private static final Pattern PATTERN_EXPORT_FILENAME = Pattern.compile("export\\.(.*?)\\.fileName", 2);
    private static final Pattern PATTERN_EXPORT_MIMETYPE = Pattern.compile("export\\.(.*?)\\.mimeType", 2);
    private static Map<ExportConfToken, Pattern> patterns = new HashMap<ExportConfToken, Pattern>();

    @Override
    public void doProcess() {
        if (StringUtils.isNotBlank((String)this.stringifiedValue)) {
            String format = null;
            ExportConfToken currentExportConfToken = null;
            for (Map.Entry<ExportConfToken, Pattern> entry : patterns.entrySet()) {
                Matcher m = entry.getValue().matcher(((ConfigToken)this.configEntry.getKey()).getPropertyName());
                if (!m.find()) continue;
                format = m.group(1);
                currentExportConfToken = entry.getKey();
                break;
            }
            if (StringUtils.isNotBlank(format)) {
                logger.debug("Export format {} found", format);
                ExportConf exportConf = null;
                if (this.tableConfiguration.getExportConfiguration().containsKey(format)) {
                    exportConf = this.tableConfiguration.getExportConfiguration().get(format);
                } else {
                    exportConf = new ExportConf(format);
                    this.tableConfiguration.getExportConfiguration().put(format, exportConf);
                }
                switch (currentExportConfToken) {
                    case CLASS: {
                        exportConf.setExportClass(this.stringifiedValue);
                        break;
                    }
                    case FILENAME: {
                        exportConf.setFileName(this.stringifiedValue);
                        break;
                    }
                    case LABEL: {
                        exportConf.setLabel(this.stringifiedValue);
                        break;
                    }
                    case MIMETYPE: {
                        exportConf.setMimeType(this.stringifiedValue);
                    }
                }
            } else {
                throw new ConfigurationProcessingException("Format " + format + " unknown");
            }
        }
    }

    static {
        patterns.put(ExportConfToken.CLASS, PATTERN_EXPORT_CLASS);
        patterns.put(ExportConfToken.LABEL, PATTERN_EXPORT_LABEL);
        patterns.put(ExportConfToken.FILENAME, PATTERN_EXPORT_FILENAME);
        patterns.put(ExportConfToken.MIMETYPE, PATTERN_EXPORT_MIMETYPE);
    }

    private static enum ExportConfToken {
        CLASS,
        LABEL,
        FILENAME,
        MIMETYPE;

    }
}

