/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.processor.export;

import com.github.dandelion.core.utils.StringUtils;
import com.github.dandelion.core.utils.UrlUtils;
import com.github.dandelion.datatables.core.export.ExportConf;
import com.github.dandelion.datatables.core.extension.feature.ExportFeature;
import com.github.dandelion.datatables.core.processor.AbstractConfigurationProcessor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ExportEnabledFormatProcessor
extends AbstractConfigurationProcessor {
    @Override
    public void doProcess() {
        if (StringUtils.isNotBlank((String)this.stringifiedValue)) {
            String[] enabledFormats;
            this.tableConfiguration.setIsExportable(true);
            for (String enabledFormat : enabledFormats = this.stringifiedValue.split(",")) {
                enabledFormat = enabledFormat.toLowerCase().trim();
                ExportConf exportConf = null;
                if (this.tableConfiguration.getExportConfiguration().containsKey(enabledFormat)) continue;
                StringBuilder exportUrl = UrlUtils.getCurrentUri((HttpServletRequest)this.tableConfiguration.getRequest());
                UrlUtils.addParameter((StringBuilder)exportUrl, (String)"dtt", (Object)"f");
                UrlUtils.addParameter((StringBuilder)exportUrl, (String)"dtf", (Object)enabledFormat);
                UrlUtils.addParameter((StringBuilder)exportUrl, (String)"dti", (Object)this.tableConfiguration.getTableId());
                UrlUtils.addParameter((StringBuilder)exportUrl, (String)"dtp", (Object)"y");
                UrlUtils.addParameter((StringBuilder)exportUrl, (String)"dandelionAssetFilterState", (Object)false);
                exportConf = new ExportConf(enabledFormat, UrlUtils.getProcessedUrl((StringBuilder)exportUrl, (HttpServletRequest)this.tableConfiguration.getRequest(), (HttpServletResponse)this.tableConfiguration.getResponse()));
                this.tableConfiguration.getExportConfiguration().put(enabledFormat, exportConf);
            }
            this.registerExtension(new ExportFeature());
        }
    }
}

