/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.processor.column;

import com.github.dandelion.core.utils.EnumUtils;
import com.github.dandelion.core.utils.StringUtils;
import com.github.dandelion.datatables.core.constants.Direction;
import com.github.dandelion.datatables.core.exception.ConfigurationProcessingException;
import com.github.dandelion.datatables.core.processor.AbstractConfigurationProcessor;
import java.util.ArrayList;

public class SortDirectionProcessor
extends AbstractConfigurationProcessor {
    @Override
    public void doProcess() {
        if (StringUtils.isNotBlank((String)this.stringifiedValue)) {
            String[] sortDirectionArray;
            ArrayList<Direction> sortDirections = new ArrayList<Direction>();
            for (String direction : sortDirectionArray = this.stringifiedValue.split(",")) {
                try {
                    sortDirections.add(Direction.valueOf(direction.toUpperCase().trim()));
                }
                catch (IllegalArgumentException e) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("'");
                    sb.append(this.stringifiedValue);
                    sb.append("' is not a valid sort direction. Possible values are: ");
                    sb.append(EnumUtils.printPossibleValuesOf(Direction.class));
                    throw new ConfigurationProcessingException(sb.toString(), e);
                }
            }
            this.updateEntry(sortDirections);
        }
    }
}

