/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.processor.column;

import com.github.dandelion.core.utils.EnumUtils;
import com.github.dandelion.core.utils.StringUtils;
import com.github.dandelion.datatables.core.exception.ConfigurationProcessingException;
import com.github.dandelion.datatables.core.extension.feature.FilterType;
import com.github.dandelion.datatables.core.processor.AbstractConfigurationProcessor;

public class FilterTypeProcessor
extends AbstractConfigurationProcessor {
    @Override
    public void doProcess() {
        if (StringUtils.isNotBlank((String)this.stringifiedValue)) {
            FilterType filterType = null;
            try {
                filterType = FilterType.valueOf(this.stringifiedValue.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                StringBuilder sb = new StringBuilder();
                sb.append("'");
                sb.append(this.stringifiedValue);
                sb.append("' is not a valid filter type. Possible values are: ");
                sb.append(EnumUtils.printPossibleValuesOf(FilterType.class));
                throw new ConfigurationProcessingException(sb.toString(), e);
            }
            this.updateEntry((Object)filterType);
        }
    }
}

