/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.processor;

import com.github.dandelion.datatables.core.configuration.ColumnConfiguration;
import com.github.dandelion.datatables.core.configuration.ConfigToken;
import com.github.dandelion.datatables.core.configuration.TableConfiguration;
import com.github.dandelion.datatables.core.extension.Extension;
import com.github.dandelion.datatables.core.processor.ConfigurationProcessor;
import com.github.dandelion.datatables.core.util.ProcessorUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigurationProcessor
implements ConfigurationProcessor {
    private static Logger logger = LoggerFactory.getLogger(AbstractConfigurationProcessor.class);
    protected HttpServletRequest request;
    protected TableConfiguration tableConfiguration;
    protected ColumnConfiguration columnConfiguration;
    protected Map<ConfigToken<?>, Object> stagingConf;
    protected Map<ConfigToken<?>, Extension> stagingExtensions;
    protected Map.Entry<ConfigToken<?>, Object> configEntry;
    protected String stringifiedValue;
    protected boolean bundleAware;

    public AbstractConfigurationProcessor() {
        this.bundleAware = false;
    }

    public AbstractConfigurationProcessor(boolean bundleAware) {
        this.bundleAware = bundleAware;
    }

    @Override
    public void process(Map.Entry<ConfigToken<?>, Object> configEntry, TableConfiguration tableConfiguration) {
        this.configEntry = configEntry;
        this.tableConfiguration = tableConfiguration;
        this.request = tableConfiguration.getRequest();
        this.stringifiedValue = configEntry.getValue() != null ? String.valueOf(configEntry.getValue()).trim() : null;
        logger.trace("Processing '{}' with the config token {}", configEntry.getValue(), configEntry.getKey());
        if (this.bundleAware) {
            this.stringifiedValue = ProcessorUtils.getValueAfterProcessingBundles(this.stringifiedValue, this.request);
            this.updateEntry(this.stringifiedValue);
        }
        this.doProcess();
    }

    @Override
    public void process(Map.Entry<ConfigToken<?>, Object> configEntry, ColumnConfiguration columnConfiguration, TableConfiguration tableConfiguration) {
        this.tableConfiguration = tableConfiguration;
        this.request = tableConfiguration.getRequest();
        this.configEntry = configEntry;
        this.columnConfiguration = columnConfiguration;
        this.stagingConf = columnConfiguration.getStagingConfigurations();
        this.stagingExtensions = columnConfiguration.getStagingExtension();
        this.stringifiedValue = String.valueOf(configEntry.getValue()).trim();
        logger.trace("Processing '{}' with the config token {}", configEntry.getValue(), configEntry.getKey());
        if (this.bundleAware) {
            this.stringifiedValue = ProcessorUtils.getValueAfterProcessingBundles(this.stringifiedValue, this.request);
            this.updateEntry(this.stringifiedValue);
        }
        this.doProcess();
    }

    protected abstract void doProcess();

    protected void registerExtension(Extension extension) {
        this.tableConfiguration.registerExtension(extension);
    }

    protected void updateEntry(Object value) {
        this.configEntry.setValue(value);
    }

    protected void addTableEntry(ConfigToken<?> configToken, Object value) {
        this.tableConfiguration.getStagingConfiguration().put(configToken, value);
    }

    protected boolean isTableEntryPresent(ConfigToken<?> configToken) {
        return this.tableConfiguration.getConfigurations().containsKey(configToken);
    }

    protected void addColumnEntry(ConfigToken<?> configToken, Object value) {
        this.columnConfiguration.getStagingConfigurations().put(configToken, value);
    }

    protected boolean isColumnEntryPresent(ConfigToken<?> configToken) {
        return this.columnConfiguration.getConfigurations().containsKey(configToken) || this.stagingConf.containsKey(configToken);
    }
}

