/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.html;

import java.util.HashMap;
import java.util.Map;

public abstract class HtmlTag {
    public static final char CLASS_SEPARATOR = ' ';
    public static final char STYLE_SEPARATOR = ';';
    protected String tag;
    protected String id;
    protected StringBuilder cssClass;
    protected StringBuilder cssStyle;
    protected Map<String, String> dynamicAttributes;

    public StringBuilder toHtml() {
        StringBuilder html = new StringBuilder();
        html.append((CharSequence)this.getHtmlOpeningTag());
        html.append((CharSequence)this.getHtmlClosingTag());
        return html;
    }

    protected StringBuilder getHtmlOpeningTag() {
        StringBuilder html = new StringBuilder();
        html.append('<');
        html.append(this.tag);
        html.append((CharSequence)this.getHtmlAttributes());
        html.append((CharSequence)this.getDynamicHtmlAttributes());
        html.append('>');
        return html;
    }

    protected StringBuilder getHtmlAttributes() {
        StringBuilder html = new StringBuilder();
        html.append((CharSequence)HtmlTag.writeAttribute("id", this.id));
        html.append((CharSequence)HtmlTag.writeAttribute("class", this.cssClass));
        html.append((CharSequence)HtmlTag.writeAttribute("style", this.cssStyle));
        return html;
    }

    protected StringBuilder getDynamicHtmlAttributes() {
        if (this.dynamicAttributes == null) {
            return new StringBuilder();
        }
        StringBuilder html = new StringBuilder();
        for (Map.Entry<String, String> attribute : this.dynamicAttributes.entrySet()) {
            html.append((CharSequence)HtmlTag.writeAttribute(attribute.getKey(), attribute.getValue()));
        }
        return html;
    }

    protected static StringBuilder writeAttribute(String name, Object data) {
        StringBuilder html = new StringBuilder();
        if (data != null) {
            html.append(' ');
            html.append(name);
            html.append("=\"");
            html.append(data.toString());
            html.append('\"');
        }
        return html;
    }

    protected StringBuilder getHtmlClosingTag() {
        StringBuilder html = new StringBuilder();
        html.append("</");
        html.append(this.tag);
        html.append('>');
        return html;
    }

    public String getTag() {
        return this.tag;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public StringBuilder getCssClass() {
        return this.cssClass;
    }

    public void setCssClass(StringBuilder cssClass) {
        this.cssClass = cssClass;
    }

    public StringBuilder getCssStyle() {
        return this.cssStyle;
    }

    public void setCssStyle(StringBuilder cssStyle) {
        this.cssStyle = cssStyle;
    }

    public Map<String, String> getDynamicAttributes() {
        return this.dynamicAttributes;
    }

    public String getDynamicAttributeValue(String attributeName) {
        if (this.dynamicAttributes != null) {
            return this.dynamicAttributes.get(attributeName);
        }
        return null;
    }

    public void setDynamicAttributes(Map<String, String> dynamicAttributes) {
        this.dynamicAttributes = dynamicAttributes;
    }

    public void addDynamicAttribute(String name, String value) {
        if (this.dynamicAttributes == null) {
            this.dynamicAttributes = new HashMap<String, String>();
        }
        this.dynamicAttributes.put(name, value);
    }

    public void removeDynamicAttribute(String attributeName) {
        if (this.dynamicAttributes != null) {
            this.dynamicAttributes.remove(attributeName);
        }
    }

    public void addCssClass(String cssClass) {
        if (this.cssClass == null) {
            this.cssClass = new StringBuilder();
        } else {
            this.cssClass.append(' ');
        }
        this.cssClass.append(cssClass);
    }

    public void addCssStyle(String cssStyle) {
        if (this.cssStyle == null) {
            this.cssStyle = new StringBuilder();
        } else {
            this.cssStyle.append(';');
        }
        this.cssStyle.append(cssStyle);
    }
}

