/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.html;

import com.github.dandelion.core.utils.StringUtils;
import com.github.dandelion.datatables.core.configuration.ColumnConfig;
import com.github.dandelion.datatables.core.configuration.ColumnConfiguration;
import com.github.dandelion.datatables.core.html.HtmlTagWithContent;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class HtmlColumn
extends HtmlTagWithContent {
    private ColumnConfiguration columnConfiguration;
    private Boolean isHeaderColumn;
    protected StringBuilder cssCellStyle;
    protected StringBuilder cssCellClass;
    private Set<String> enabledDisplayTypes = new HashSet<String>();

    public HtmlColumn() {
        this.setHeaderColumn(false);
        this.enabledDisplayTypes.add("all");
    }

    public HtmlColumn(String displayFormat) {
        this.setHeaderColumn(false);
        this.enabledDisplayTypes.add(displayFormat);
    }

    public HtmlColumn(Boolean isHeader) {
        this.setHeaderColumn(isHeader);
        this.enabledDisplayTypes.add("all");
        if (isHeader.booleanValue()) {
            this.columnConfiguration = new ColumnConfiguration();
        }
    }

    public HtmlColumn(Boolean isHeader, String content) {
        this.setHeaderColumn(isHeader);
        this.enabledDisplayTypes.add("all");
        if (isHeader.booleanValue()) {
            this.columnConfiguration = new ColumnConfiguration();
        }
        if (content != null) {
            this.setContent(new StringBuilder(content));
        }
    }

    public HtmlColumn(Boolean isHeader, String content, Map<String, String> dynamicAttributes) {
        this.setHeaderColumn(isHeader);
        this.enabledDisplayTypes.add("all");
        if (isHeader.booleanValue()) {
            this.columnConfiguration = new ColumnConfiguration();
        }
        if (content != null) {
            this.setContent(new StringBuilder(content));
        }
        this.dynamicAttributes = dynamicAttributes;
    }

    public HtmlColumn(Boolean isHeader, String content, Map<String, String> dynamicAttributes, String displayTypes) {
        this.setHeaderColumn(isHeader);
        if (isHeader.booleanValue()) {
            this.columnConfiguration = new ColumnConfiguration();
        }
        if (content != null) {
            this.setContent(new StringBuilder(content));
        }
        this.dynamicAttributes = dynamicAttributes;
        if (StringUtils.isNotBlank((String)displayTypes)) {
            String[] displayTypesTab;
            for (String displayType : displayTypesTab = displayTypes.trim().split(",")) {
                this.enabledDisplayTypes.add(displayType.toLowerCase().trim());
            }
        } else {
            this.enabledDisplayTypes.add("all");
        }
    }

    @Override
    protected StringBuilder getHtmlAttributes() {
        StringBuilder html = new StringBuilder();
        if (this.isHeaderColumn.booleanValue()) {
            html.append((CharSequence)HtmlColumn.writeAttribute("class", ColumnConfig.CSSCLASS.valueFrom(this.getColumnConfiguration())));
            html.append((CharSequence)HtmlColumn.writeAttribute("style", ColumnConfig.CSSSTYLE.valueFrom(this.getColumnConfiguration())));
            String columnId = ColumnConfig.ID.valueFrom(this.getColumnConfiguration());
            if (StringUtils.isNotBlank((String)columnId)) {
                html.append((CharSequence)HtmlColumn.writeAttribute("id", columnId));
            }
        } else {
            html.append((CharSequence)HtmlColumn.writeAttribute("class", this.cssCellClass));
            html.append((CharSequence)HtmlColumn.writeAttribute("style", this.cssCellStyle));
        }
        return html;
    }

    private void setHeaderColumn(Boolean isHeaderColumn) {
        this.isHeaderColumn = isHeaderColumn;
        this.tag = this.isHeaderColumn != false ? "th" : "td";
    }

    public Boolean isHeaderColumn() {
        return this.isHeaderColumn;
    }

    public ColumnConfiguration getColumnConfiguration() {
        return this.columnConfiguration;
    }

    public void setColumnConfiguration(ColumnConfiguration columnConfiguration) {
        this.columnConfiguration = columnConfiguration;
    }

    @Override
    public void addCssClass(String cssClass) {
        if (this.isHeaderColumn.booleanValue()) {
            StringBuilder cssClassSb = ColumnConfig.CSSCLASS.valueFrom(this.columnConfiguration);
            if (cssClassSb != null && cssClassSb.length() != 0) {
                ColumnConfig.CSSCLASS.appendIn(this.columnConfiguration, ' ');
            }
            ColumnConfig.CSSCLASS.appendIn(this.columnConfiguration, cssClass);
        } else {
            if (this.cssClass == null) {
                this.cssClass = new StringBuilder();
            } else {
                this.cssClass.append(' ');
            }
            this.cssClass.append(cssClass);
        }
    }

    public void addCssCellClass(String cssCellClass) {
        if (this.cssCellClass == null) {
            this.cssCellClass = new StringBuilder();
        } else {
            this.cssCellClass.append(' ');
        }
        this.cssCellClass.append(cssCellClass);
    }

    public void addCssCellStyle(String cssCellStyle) {
        if (this.cssCellStyle == null) {
            this.cssCellStyle = new StringBuilder();
        } else {
            this.cssCellStyle.append(';');
        }
        this.cssCellStyle.append(cssCellStyle);
    }

    public Set<String> getEnabledDisplayTypes() {
        return this.enabledDisplayTypes;
    }

    public void setEnabledDisplayTypes(Set<String> enabledDisplayTypes) {
        this.enabledDisplayTypes = enabledDisplayTypes;
    }

    public StringBuilder getCssCellStyle() {
        return this.cssCellStyle;
    }

    public StringBuilder getCssCellClass() {
        return this.cssCellClass;
    }
}

