/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.html;

import com.github.dandelion.core.utils.StringUtils;

public class ExtraHtml {
    private String uid;
    private String container = "div";
    private String cssStyle;
    private String cssClass;
    private String content;

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getContainer() {
        return this.container;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public String getCssStyle() {
        return this.cssStyle;
    }

    public void setCssStyle(String cssStyle) {
        this.cssStyle = cssStyle;
    }

    public String getCssClass() {
        return this.cssClass;
    }

    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public StringBuilder getJavascript() {
        StringBuilder js = new StringBuilder();
        js.append("$.fn.dataTableExt.aoFeatures.push({");
        js.append("\"fnInit\": function( oDTSettings ){");
        js.append("var container = document.createElement('" + this.container + "');");
        if (StringUtils.isNotBlank((String)this.cssClass)) {
            js.append("$(container).attr('class', '" + this.cssClass + "');");
        }
        if (StringUtils.isNotBlank((String)this.cssStyle)) {
            js.append("$(container).attr('style', '" + this.cssStyle + "');");
        }
        js.append("$(container).html('" + this.content.replaceAll("'", "&quot;") + "');");
        js.append("return container;");
        js.append("},");
        js.append("\"cFeature\": \"" + this.uid + "\",");
        js.append("\"sFeature\": \"Group" + this.uid + "\"");
        js.append("} );");
        return js;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.container == null ? 0 : this.container.hashCode());
        result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
        result = 31 * result + (this.cssClass == null ? 0 : this.cssClass.hashCode());
        result = 31 * result + (this.cssStyle == null ? 0 : this.cssStyle.hashCode());
        result = 31 * result + (this.uid == null ? 0 : this.uid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExtraHtml other = (ExtraHtml)obj;
        if (this.container == null ? other.container != null : !this.container.equals(other.container)) {
            return false;
        }
        if (this.content == null ? other.content != null : !this.content.equals(other.content)) {
            return false;
        }
        if (this.cssClass == null ? other.cssClass != null : !this.cssClass.equals(other.cssClass)) {
            return false;
        }
        if (this.cssStyle == null ? other.cssStyle != null : !this.cssStyle.equals(other.cssStyle)) {
            return false;
        }
        return !(this.uid == null ? other.uid != null : !this.uid.equals(other.uid));
    }

    public String toString() {
        return "ExtraHtml [uid=" + this.uid + ", container=" + this.container + ", cssStyle=" + this.cssStyle + ", cssClass=" + this.cssClass + ", content=" + this.content + "]";
    }
}

