/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.generator.javascript;

import com.github.dandelion.datatables.core.asset.JsResource;
import com.github.dandelion.datatables.core.generator.javascript.JavascriptGenerator;
import javax.servlet.http.HttpServletRequest;

public class StandardJavascriptGenerator
implements JavascriptGenerator {
    private StringBuilder beforeAll;
    private StringBuilder variables;
    private StringBuilder beforeStartDocumentReady;
    private StringBuilder documentReady;
    private StringBuilder afterStartDocumentReady;
    private StringBuilder beforeEndDocumentReady;
    private StringBuilder afterEndDocumentReady;
    private StringBuilder afterAll;

    @Override
    public void addResource(JsResource jsResource) {
        this.appendToBeforeAll(jsResource);
        this.appendVariables(jsResource);
        this.appendToBeforeStartDocumentReady(jsResource);
        this.appendToDocumentReady(jsResource);
        this.appendToAfterStartDocumentReady(jsResource);
        this.appendToBeforeEndDocumentReady(jsResource);
        this.appendToAfterAll(jsResource);
    }

    private void appendToAfterStartDocumentReady(JsResource jsResource) {
        if (jsResource.getAfterStartDocumentReady() != null) {
            if (this.afterStartDocumentReady == null) {
                this.afterStartDocumentReady = new StringBuilder();
            }
            this.afterStartDocumentReady.append((CharSequence)jsResource.getAfterStartDocumentReady());
        }
    }

    private void appendToAfterAll(JsResource jsResource) {
        if (jsResource.getAfterAll() != null) {
            if (this.afterAll == null) {
                this.afterAll = new StringBuilder();
            }
            this.afterAll.append((CharSequence)jsResource.getAfterAll());
        }
    }

    private void appendToBeforeEndDocumentReady(JsResource jsResource) {
        if (jsResource.getBeforeEndDocumentReady() != null) {
            if (this.beforeEndDocumentReady == null) {
                this.beforeEndDocumentReady = new StringBuilder();
            }
            this.beforeEndDocumentReady.append("   ").append((CharSequence)jsResource.getBeforeEndDocumentReady());
        }
    }

    private void appendToDocumentReady(JsResource jsResource) {
        String tableId = jsResource.getProcessedId();
        if (this.documentReady == null) {
            this.documentReady = new StringBuilder();
        }
        this.documentReady.append("   ").append("oTable_").append(tableId).append(".dataTable(oTable_").append(tableId).append("_params)");
        if (jsResource.getDataTablesExtra() != null) {
            this.documentReady.append(".");
            this.documentReady.append((CharSequence)jsResource.getDataTablesExtra());
            this.documentReady.append("(");
            if (jsResource.getDataTablesExtraConf() != null) {
                this.documentReady.append((CharSequence)jsResource.getDataTablesExtraConf());
            }
            this.documentReady.append(")");
        }
        this.documentReady.append(";").append("\n");
    }

    private void appendToBeforeStartDocumentReady(JsResource jsResource) {
        if (jsResource.getBeforeStartDocumentReady() != null) {
            if (this.beforeStartDocumentReady == null) {
                this.beforeStartDocumentReady = new StringBuilder();
            }
            this.beforeStartDocumentReady.append((CharSequence)jsResource.getBeforeStartDocumentReady());
        }
    }

    private void appendVariables(JsResource jsResource) {
        String tableId = jsResource.getProcessedId();
        String originalId = jsResource.getOriginalId();
        if (this.variables == null) {
            this.variables = new StringBuilder();
        }
        this.variables.append("var oTable_").append(tableId).append(" = $('#").append(originalId).append("');").append("\n");
        this.variables.append("var oTable_").append(tableId).append("_params = ").append((CharSequence)jsResource.getDataTablesConf()).append("\n");
    }

    private void appendToBeforeAll(JsResource jsResource) {
        if (jsResource.getBeforeAll() != null) {
            if (this.beforeAll == null) {
                this.beforeAll = new StringBuilder();
            }
            this.beforeAll.append((CharSequence)jsResource.getBeforeAll());
        }
    }

    public String getContent(HttpServletRequest request) {
        StringBuilder retval = new StringBuilder();
        if (this.beforeAll != null) {
            retval.append((CharSequence)this.beforeAll);
        }
        retval.append((CharSequence)this.variables).append("\n");
        if (this.beforeStartDocumentReady != null) {
            retval.append((CharSequence)this.beforeStartDocumentReady);
        }
        retval.append("$(document).ready(function(){").append("\n");
        if (this.afterStartDocumentReady != null) {
            retval.append((CharSequence)this.afterStartDocumentReady);
        }
        if (this.documentReady != null) {
            retval.append((CharSequence)this.documentReady);
        }
        if (this.beforeEndDocumentReady != null) {
            retval.append((CharSequence)this.beforeEndDocumentReady);
        }
        retval.append("});").append("\n");
        if (this.afterEndDocumentReady != null) {
            retval.append((CharSequence)this.afterEndDocumentReady);
        }
        if (this.afterAll != null) {
            retval.append((CharSequence)this.afterAll).append("\n");
        }
        return retval.toString();
    }
}

