/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.generator.configuration;

import com.github.dandelion.core.utils.StringUtils;
import com.github.dandelion.datatables.core.asset.JavascriptSnippet;
import com.github.dandelion.datatables.core.callback.Callback;
import com.github.dandelion.datatables.core.configuration.ColumnConfig;
import com.github.dandelion.datatables.core.configuration.ColumnConfiguration;
import com.github.dandelion.datatables.core.configuration.TableConfig;
import com.github.dandelion.datatables.core.configuration.TableConfiguration;
import com.github.dandelion.datatables.core.constants.DTMessages;
import com.github.dandelion.datatables.core.constants.Direction;
import com.github.dandelion.datatables.core.extension.feature.PaginationType;
import com.github.dandelion.datatables.core.generator.configuration.AbstractConfigurationGenerator;
import com.github.dandelion.datatables.core.html.HtmlColumn;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.util.CollectionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatatablesGenerator
extends AbstractConfigurationGenerator {
    private static Logger logger = LoggerFactory.getLogger(DatatablesGenerator.class);

    @Override
    public Map<String, Object> generateConfig(HtmlTable table) {
        TableConfiguration tableConfiguration = table.getTableConfiguration();
        logger.debug("Generating DataTables configuration ..");
        HashMap<String, Object> mainConf = new HashMap<String, Object>();
        this.generateColumnConfiguration(mainConf, table, tableConfiguration);
        this.generateI18nConfiguration(mainConf, tableConfiguration);
        this.generateFeatureEnablementConfiguration(mainConf, tableConfiguration);
        this.generateScrollingConfiguration(mainConf, tableConfiguration);
        this.generateMiscConfiguration(mainConf, tableConfiguration);
        this.generateAjaxConfiguration(mainConf, tableConfiguration);
        this.generateCallbackConfiguration(mainConf, tableConfiguration);
        logger.debug("DataTables configuration generated");
        return mainConf;
    }

    private void generateScrollingConfiguration(Map<String, Object> mainConf, TableConfiguration tableConfiguration) {
        String featureScrollY = TableConfig.FEATURE_SCROLLY.valueFrom(tableConfiguration);
        Boolean featureScrollCollapse = TableConfig.FEATURE_SCROLLCOLLAPSE.valueFrom(tableConfiguration);
        String featureScrollX = TableConfig.FEATURE_SCROLLX.valueFrom(tableConfiguration);
        String featureScrollXInner = TableConfig.FEATURE_SCROLLXINNER.valueFrom(tableConfiguration);
        if (StringUtils.isNotBlank((String)featureScrollY)) {
            mainConf.put("sScrollY", featureScrollY);
        }
        if (featureScrollCollapse != null) {
            mainConf.put("bScrollCollapse", featureScrollCollapse);
        }
        if (StringUtils.isNotBlank((String)featureScrollX)) {
            mainConf.put("sScrollX", featureScrollX);
        }
        if (StringUtils.isNotBlank((String)featureScrollXInner)) {
            mainConf.put("sScrollXInner", featureScrollXInner);
        }
    }

    private void generateFeatureEnablementConfiguration(Map<String, Object> mainConf, TableConfiguration tableConfiguration) {
        Boolean featureFilterable = TableConfig.FEATURE_FILTERABLE.valueFrom(tableConfiguration);
        Boolean featureInfo = TableConfig.FEATURE_INFO.valueFrom(tableConfiguration);
        Boolean featurePaginate = TableConfig.FEATURE_PAGEABLE.valueFrom(tableConfiguration);
        Boolean featureSort = TableConfig.FEATURE_SORTABLE.valueFrom(tableConfiguration);
        if (featureFilterable != null) {
            mainConf.put("bFilter", featureFilterable);
        }
        if (featureInfo != null) {
            mainConf.put("bInfo", featureInfo);
        }
        if (featurePaginate != null) {
            mainConf.put("bPaginate", featurePaginate);
        }
        if (featureSort != null) {
            mainConf.put("bSort", featureSort);
        }
    }

    private void generateMiscConfiguration(Map<String, Object> mainConf, TableConfiguration tableConfiguration) {
        String featureDom = TableConfig.FEATURE_DOM.valueFrom(tableConfiguration);
        Boolean featureAutoWidth = TableConfig.FEATURE_AUTOWIDTH.valueFrom(tableConfiguration);
        String featureLengthMenu = TableConfig.FEATURE_LENGTHMENU.valueFrom(tableConfiguration);
        String cssStripeClasses = TableConfig.CSS_STRIPECLASSES.valueFrom(tableConfiguration);
        Integer featureDisplayLength = TableConfig.FEATURE_DISPLAYLENGTH.valueFrom(tableConfiguration);
        Boolean featureLengthChange = TableConfig.FEATURE_LENGTHCHANGE.valueFrom(tableConfiguration);
        PaginationType featurePaginationType = TableConfig.FEATURE_PAGINATIONTYPE.valueFrom(tableConfiguration);
        Boolean featureStateSave = TableConfig.FEATURE_STATESAVE.valueFrom(tableConfiguration);
        Boolean featureJqueryUi = TableConfig.FEATURE_JQUERYUI.valueFrom(tableConfiguration);
        if (StringUtils.isNotBlank((String)featureDom)) {
            mainConf.put("sDom", featureDom);
        }
        if (featureAutoWidth != null) {
            mainConf.put("bAutoWidth", featureAutoWidth);
        }
        if (featureDisplayLength != null) {
            mainConf.put("iDisplayLength", featureDisplayLength);
        }
        if (featureLengthChange != null) {
            mainConf.put("bLengthChange", featureLengthChange);
        }
        if (featurePaginationType != null) {
            mainConf.put("sPaginationType", featurePaginationType.toString());
        }
        if (featureStateSave != null) {
            mainConf.put("bStateSave", featureStateSave);
        }
        if (featureJqueryUi != null) {
            mainConf.put("bJQueryUI", featureJqueryUi);
        }
        if (StringUtils.isNotBlank((String)featureLengthMenu)) {
            mainConf.put("aLengthMenu", new JavascriptSnippet(featureLengthMenu));
        }
        if (StringUtils.isNotBlank((String)cssStripeClasses)) {
            mainConf.put("asStripeClasses", new JavascriptSnippet(cssStripeClasses));
        }
    }

    private void generateColumnConfiguration(Map<String, Object> mainConf, HtmlTable table, TableConfiguration tableConfiguration) {
        HashMap<String, Object> tmp = null;
        ArrayList aoColumnsContent = new ArrayList();
        for (HtmlColumn column : table.getLastHeaderRow().getColumns()) {
            String sortType;
            List<Direction> sortDirections;
            String defaultValue;
            String renderFunction;
            String property;
            Boolean visible;
            Boolean searchable;
            Boolean bl;
            ColumnConfiguration columnConfiguration = column.getColumnConfiguration();
            Set<String> enabledDisplayTypes = column.getEnabledDisplayTypes();
            if (!CollectionUtils.containsAny(enabledDisplayTypes, "all", "html")) continue;
            tmp = new HashMap<String, Object>();
            String name = ColumnConfig.NAME.valueFrom(columnConfiguration);
            if (StringUtils.isNotBlank((String)name)) {
                tmp.put("sName", name);
            }
            if ((bl = ColumnConfig.SORTABLE.valueFrom(columnConfiguration)) != null) {
                tmp.put("bSortable", bl);
            }
            if ((searchable = ColumnConfig.SEARCHABLE.valueFrom(columnConfiguration)) != null) {
                tmp.put("bSearchable", searchable);
            }
            if ((visible = ColumnConfig.VISIBLE.valueFrom(columnConfiguration)) != null) {
                tmp.put("bVisible", visible);
            }
            if (StringUtils.isNotBlank((String)(property = ColumnConfig.PROPERTY.valueFrom(columnConfiguration)))) {
                tmp.put("mData", property);
            }
            if (StringUtils.isNotBlank((String)(renderFunction = ColumnConfig.RENDERFUNCTION.valueFrom(columnConfiguration)))) {
                tmp.put("mRender", new JavascriptSnippet(renderFunction));
            }
            if ((defaultValue = ColumnConfig.DEFAULTVALUE.valueFrom(columnConfiguration)) != null) {
                tmp.put("sDefaultContent", defaultValue);
            } else {
                tmp.put("sDefaultContent", "");
            }
            StringBuilder cssCellClass = ColumnConfig.CSSCELLCLASS.valueFrom(columnConfiguration);
            if (StringUtils.isNotBlank((String)TableConfig.AJAX_SOURCE.valueFrom(table)) && cssCellClass != null && StringUtils.isNotBlank((String)cssCellClass.toString())) {
                tmp.put("sClass", cssCellClass.toString());
            }
            if ((sortDirections = ColumnConfig.SORTDIRECTION.valueFrom(columnConfiguration)) != null) {
                ArrayList<String> directions = new ArrayList<String>();
                for (Direction direction : sortDirections) {
                    directions.add(direction.value);
                }
                tmp.put("asSorting", directions);
            }
            if (StringUtils.isNotBlank((String)(sortType = ColumnConfig.SORTTYPE.valueFrom(columnConfiguration)))) {
                tmp.put("sType", sortType);
            }
            aoColumnsContent.add(tmp);
        }
        mainConf.put("aoColumns", aoColumnsContent);
        ArrayList<Integer> aaSortingtmp = null;
        ArrayList aaSortingContent = new ArrayList();
        TreeMap sortedColumnMap = new TreeMap();
        int columnIndex = 0;
        for (HtmlColumn htmlColumn : table.getLastHeaderRow().getColumns("all", "html")) {
            HashMap<Integer, String> value;
            String sortInitDirection = ColumnConfig.SORTINITDIRECTION.valueFrom(htmlColumn.getColumnConfiguration());
            Integer sortInitOrder = ColumnConfig.SORTINITORDER.valueFrom(htmlColumn.getColumnConfiguration());
            if (sortInitOrder != null && StringUtils.isNotBlank((String)sortInitDirection)) {
                value = new HashMap<Integer, String>();
                value.put(columnIndex, sortInitDirection);
                sortedColumnMap.put(sortInitOrder, value);
            } else if (StringUtils.isNotBlank((String)sortInitDirection)) {
                value = new HashMap();
                value.put(columnIndex, sortInitDirection);
                sortedColumnMap.put(sortedColumnMap.keySet().size(), value);
            }
            ++columnIndex;
        }
        for (Map.Entry entry : sortedColumnMap.entrySet()) {
            aaSortingtmp = new ArrayList<Integer>();
            Integer key = (Integer)((Map)entry.getValue()).entrySet().iterator().next().getKey();
            aaSortingtmp.add(key);
            aaSortingtmp.add((Integer)((Map)entry.getValue()).get(key));
            aaSortingContent.add(aaSortingtmp);
        }
        if (!aaSortingContent.isEmpty()) {
            mainConf.put("aaSorting", aaSortingContent);
        }
    }

    private void generateI18nConfiguration(Map<String, Object> mainConf, TableConfiguration tableConfiguration) {
        HashMap<String, Object> languageMap = new HashMap<String, Object>();
        HashMap<String, Object> languagePaginateMap = new HashMap<String, Object>();
        HashMap<String, Object> languageAriaMap = new HashMap<String, Object>();
        if (tableConfiguration.getMessages() != null && tableConfiguration.getMessages().size() > 0) {
            block0: for (Map.Entry<Object, Object> entry : tableConfiguration.getMessages().entrySet()) {
                for (DTMessages conf : DTMessages.values()) {
                    if (!entry.getKey().equals(conf.getPropertyName())) continue;
                    if (entry.getKey().toString().contains("paginate")) {
                        languagePaginateMap.put(conf.getRealName(), entry.getValue());
                        continue block0;
                    }
                    if (entry.getKey().toString().contains("aria")) {
                        languageAriaMap.put(conf.getRealName(), entry.getValue());
                        continue block0;
                    }
                    languageMap.put(conf.getRealName(), entry.getValue());
                    continue block0;
                }
            }
        }
        if (languagePaginateMap.size() > 0) {
            languageMap.put(DTMessages.PAGINATE.getRealName(), languagePaginateMap);
        }
        if (languageAriaMap.size() > 0) {
            languageMap.put(DTMessages.ARIA.getRealName(), languageAriaMap);
        }
        if (languageMap.size() > 0) {
            mainConf.put("oLanguage", languageMap);
        }
    }

    private void generateAjaxConfiguration(Map<String, Object> mainConf, TableConfiguration tableConfiguration) {
        Boolean ajaxProcessing = TableConfig.FEATURE_PROCESSING.valueFrom(tableConfiguration);
        Boolean ajaxDeferRender = TableConfig.AJAX_DEFERRENDER.valueFrom(tableConfiguration);
        Boolean ajaxServerSide = TableConfig.AJAX_SERVERSIDE.valueFrom(tableConfiguration);
        if (ajaxProcessing != null) {
            mainConf.put("bProcessing", ajaxProcessing);
        }
        if (ajaxDeferRender != null) {
            mainConf.put("bDeferRender", ajaxDeferRender);
        }
        if (ajaxServerSide != null) {
            String ajaxSource = TableConfig.AJAX_SOURCE.valueFrom(tableConfiguration);
            String ajaxServerData = TableConfig.AJAX_SERVERDATA.valueFrom(tableConfiguration);
            String ajaxServerParam = TableConfig.AJAX_SERVERPARAM.valueFrom(tableConfiguration);
            String ajaxServerMethod = TableConfig.AJAX_SERVERMETHOD.valueFrom(tableConfiguration);
            mainConf.put("bServerSide", ajaxServerSide);
            if (StringUtils.isNotBlank((String)ajaxSource)) {
                mainConf.put("sAjaxSource", ajaxSource);
            }
            if (StringUtils.isNotBlank((String)ajaxServerData)) {
                mainConf.put("fnServerData", new JavascriptSnippet(ajaxServerData));
            }
            if (StringUtils.isNotBlank((String)ajaxServerParam)) {
                mainConf.put("fnServerParams", new JavascriptSnippet(ajaxServerParam));
            }
            if (StringUtils.isNotBlank((String)ajaxServerMethod)) {
                mainConf.put("sServerMethod", ajaxServerMethod);
            }
        }
    }

    private void generateCallbackConfiguration(Map<String, Object> mainConf, TableConfiguration tableConfiguration) {
        if (tableConfiguration.getCallbacks() != null) {
            for (Callback callback : tableConfiguration.getCallbacks()) {
                mainConf.put(callback.getType().getName(), callback.getFunction());
            }
        }
    }
}

