/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.extension.theme;

import com.github.dandelion.datatables.core.asset.JavascriptSnippet;
import com.github.dandelion.datatables.core.configuration.DatatableBundles;
import com.github.dandelion.datatables.core.configuration.TableConfig;
import com.github.dandelion.datatables.core.exception.ExtensionLoadingException;
import com.github.dandelion.datatables.core.extension.AbstractExtension;
import com.github.dandelion.datatables.core.extension.feature.PaginationType;
import com.github.dandelion.datatables.core.extension.theme.ThemeOption;
import com.github.dandelion.datatables.core.html.HtmlTable;

public class Bootstrap2Theme
extends AbstractExtension {
    @Override
    public String getName() {
        return "bootstrap2";
    }

    @Override
    public void setup(HtmlTable table) {
        ThemeOption themeOption;
        this.addBundle(DatatableBundles.DDL_DT_THEME_BOOTSTRAP2);
        Boolean paging = TableConfig.FEATURE_PAGEABLE.valueFrom(table);
        if (paging != null && paging.booleanValue()) {
            this.addBundle(DatatableBundles.DDL_DT_PAGING_BOOTSTRAP);
            if (TableConfig.FEATURE_PAGINATIONTYPE.valueFrom(table.getTableConfiguration()) == null) {
                this.addParameter("sPaginationType", PaginationType.BOOTSTRAP.toString());
            }
        }
        if ((themeOption = TableConfig.CSS_THEMEOPTION.valueFrom(table)) != null) {
            if (themeOption.equals((Object)ThemeOption.TABLECLOTH)) {
                this.addBundle(DatatableBundles.DDL_DT_THEME_BOOTSTRAP2_TABLECLOTH);
            } else {
                throw new ExtensionLoadingException("Only the 'tablecloth' theme option is compatible with the 'bootstrap2' theme");
            }
        }
        this.addParameter("asStripeClasses", new JavascriptSnippet("[]"));
    }
}

