/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.extension.feature;

import com.github.dandelion.core.utils.StringUtils;
import com.github.dandelion.datatables.core.configuration.ColumnConfig;
import com.github.dandelion.datatables.core.configuration.DatatableBundles;
import com.github.dandelion.datatables.core.extension.AbstractExtension;
import com.github.dandelion.datatables.core.extension.feature.SortType;
import com.github.dandelion.datatables.core.html.HtmlColumn;
import com.github.dandelion.datatables.core.html.HtmlTable;
import java.util.HashSet;

public class SortingFeature
extends AbstractExtension {
    @Override
    public String getName() {
        return "SortingFeature";
    }

    @Override
    public void setup(HtmlTable table) {
        HashSet<SortType> enabledSortTypes = new HashSet<SortType>();
        for (HtmlColumn column : table.getLastHeaderRow().getColumns()) {
            SortType sortType;
            String sortTypeString = ColumnConfig.SORTTYPE.valueFrom(column.getColumnConfiguration());
            if (!StringUtils.isNotBlank((String)sortTypeString) || (sortType = SortType.findByName(sortTypeString)) == null) continue;
            enabledSortTypes.add(sortType);
        }
        for (SortType sortType : enabledSortTypes) {
            switch (sortType) {
                case DATE: {
                    this.addBundle(DatatableBundles.DDL_DT_SORTING_DATE_UK);
                    break;
                }
                case NATURAL: {
                    this.addBundle(DatatableBundles.DDL_DT_SORTING_NATURAL);
                    break;
                }
                case ALT_STRING: {
                    this.addBundle(DatatableBundles.DDL_DT_SORTING_ALT_STRING);
                    break;
                }
                case ANTI_THE: {
                    this.addBundle(DatatableBundles.DDL_DT_SORTING_ANTI_THE);
                    break;
                }
                case CURRENCY: {
                    this.addBundle(DatatableBundles.DDL_DT_SORTING_CURRENCY);
                    break;
                }
                case FILESIZE: {
                    this.addBundle(DatatableBundles.DDL_DT_SORTING_FILESIZE);
                    break;
                }
                case FORMATTED_NUMBERS: {
                    this.addBundle(DatatableBundles.DDL_DT_SORTING_FORMATTED_NUMBER);
                }
            }
        }
    }
}

