/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.extension.feature;

import com.github.dandelion.core.utils.StringUtils;

public enum SortType {
    DATE("date-uk"),
    NATURAL("natural"),
    ANTI_THE("anti-the"),
    ALT_STRING("alt-string"),
    CURRENCY("currency"),
    FILESIZE("file-size"),
    FORMATTED_NUMBERS("formatted-num");

    private String name;

    private SortType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static SortType findByName(String name) {
        if (StringUtils.isBlank((String)name)) {
            return null;
        }
        for (SortType sortType : SortType.values()) {
            if (!name.trim().equalsIgnoreCase(sortType.getName())) continue;
            return sortType;
        }
        return null;
    }
}

