/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.extension.feature;

import com.github.dandelion.core.utils.StringUtils;
import com.github.dandelion.datatables.core.configuration.ColumnConfig;
import com.github.dandelion.datatables.core.configuration.DatatableBundles;
import com.github.dandelion.datatables.core.configuration.TableConfig;
import com.github.dandelion.datatables.core.exception.ExtensionLoadingException;
import com.github.dandelion.datatables.core.extension.AbstractExtension;
import com.github.dandelion.datatables.core.extension.feature.FilterPlaceholder;
import com.github.dandelion.datatables.core.html.HtmlColumn;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.util.JavascriptUtils;
import java.util.HashSet;

public class MultiFilterFeature
extends AbstractExtension {
    private static final char NEWLINE = '\n';

    @Override
    public String getName() {
        return "multifilter";
    }

    @Override
    public void setup(HtmlTable table) {
        this.checkConfiguration(table);
        this.addBundle(DatatableBundles.DDL_DT_MULTIFILTER);
        String filterSelector = TableConfig.FEATURE_FILTER_SELECTOR.valueFrom(table.getTableConfiguration());
        String filterClearSelector = TableConfig.FEATURE_FILTER_CLEAR_SELECTOR.valueFrom(table.getTableConfiguration());
        HashSet<String> selectors = null;
        StringBuilder js = null;
        FilterPlaceholder filterPlaceholder = TableConfig.FEATURE_FILTER_PLACEHOLDER.valueFrom(table);
        if (filterPlaceholder != null && filterPlaceholder.equals((Object)FilterPlaceholder.NONE)) {
            selectors = new HashSet<String>();
            for (HtmlColumn column : table.getLastHeaderRow().getColumns()) {
                String selector = ColumnConfig.SELECTOR.valueFrom(column.getColumnConfiguration());
                if (!StringUtils.isNotBlank((String)selector)) continue;
                selectors.add(selector);
            }
            js = new StringBuilder(10);
            js.append("$('").append(filterSelector).append("').click(function() {").append('\n');
            js.append("   var filterParams = {};").append('\n');
            js.append("   $.each(").append(JavascriptUtils.toArray(selectors)).append(", function(i, selector){").append('\n');
            js.append("      $(selector + ' .dandelion_column_filter').each(function (index) {").append('\n');
            js.append("         if(!$(this).hasClass('search_init') && $(this).val() != ''){").append('\n');
            js.append("            filterParams[$(this).attr('data-column-name')] = $(this).val();").append('\n');
            js.append("         }").append('\n');
            js.append("      });").append('\n');
            js.append("   });").append('\n');
            js.append("   oTable_").append(table.getId()).append(".fnMultiFilter( filterParams );").append('\n');
            js.append("});").append('\n');
        } else {
            js = new StringBuilder(10);
            js.append("$('" + filterSelector + "').click(function() {").append('\n');
            js.append("   var filterParams = {};").append('\n');
            js.append("   $('#").append(table.getId()).append(" .dandelion_column_filter').each(function (index) {;").append('\n');
            js.append("      if(!$(this).hasClass('search_init') && $(this).val() != ''){").append('\n');
            js.append("         filterParams[$(this).attr('data-column-name')] = $(this).val();").append('\n');
            js.append("      }").append('\n');
            js.append("   });").append('\n');
            js.append("   oTable_").append(table.getId()).append(".fnMultiFilter( filterParams );").append('\n');
            js.append("});");
        }
        this.appendToBeforeEndDocumentReady(js.toString());
        if (StringUtils.isNotBlank((String)filterClearSelector)) {
            if (FilterPlaceholder.NONE.equals((Object)filterPlaceholder)) {
                js = new StringBuilder(10);
                js.append("$('").append(filterClearSelector).append("').click(function() {").append('\n');
                js.append("   oTable_").append(table.getId()).append(".fnFilterClear();").append('\n');
                js.append("   $.each(" + JavascriptUtils.toArray(selectors) + ", function(i, selector){").append('\n');
                js.append("      $(selector + ' .dandelion_column_filter').each(function (index) {").append('\n');
                js.append("         $(this).val('');").append('\n');
                js.append("         $(this).trigger('blur');").append('\n');
                js.append("      });").append('\n');
                js.append("   });").append('\n');
                js.append("});").append('\n');
            } else {
                js = new StringBuilder(10);
                js.append("$('").append(filterClearSelector).append("').click(function() {").append('\n');
                js.append("   $('#").append(table.getId()).append(" .dandelion_column_filter').each(function (index) {;").append('\n');
                js.append("      $(this).val('');").append('\n');
                js.append("      $(this).trigger('blur');").append('\n');
                js.append("   });").append('\n');
                js.append("   oTable_").append(table.getId()).append(".fnFilterClear();").append('\n');
                js.append("});").append('\n');
            }
            this.appendToBeforeEndDocumentReady(js.toString());
        }
    }

    private void checkConfiguration(HtmlTable table) {
        String buttonId = TableConfig.FEATURE_FILTER_SELECTOR.valueFrom(table.getTableConfiguration());
        if (StringUtils.isBlank((String)buttonId)) {
            StringBuilder msg = new StringBuilder();
            msg.append("A filter button must be set in order to make the multi-filter work.");
            msg.append(" Please use the filterButton/dt:filterButton (JSP/Thymeleaf) table attribute.");
            throw new ExtensionLoadingException(msg.toString());
        }
        HashSet<String> columnWithoutName = new HashSet<String>();
        for (HtmlColumn headerColumn : table.getLastHeaderRow().getColumns()) {
            String name = ColumnConfig.NAME.valueFrom(headerColumn.getColumnConfiguration());
            if (!StringUtils.isBlank((String)name)) continue;
            columnWithoutName.add(name);
        }
        if (!columnWithoutName.isEmpty()) {
            StringBuilder msg = new StringBuilder();
            msg.append("All columns must have a name in order to make the multi-filter work.");
            msg.append(" Please use the name/dt:name (JSP/Thymeleaf) column attribute to assign a name to each column.");
            throw new ExtensionLoadingException(msg.toString());
        }
    }
}

