/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.extension.feature;

import com.github.dandelion.core.utils.StringUtils;
import com.github.dandelion.datatables.core.asset.Parameter;
import com.github.dandelion.datatables.core.configuration.DatatableBundles;
import com.github.dandelion.datatables.core.configuration.TableConfig;
import com.github.dandelion.datatables.core.export.ExportConf;
import com.github.dandelion.datatables.core.export.HttpMethod;
import com.github.dandelion.datatables.core.extension.AbstractExtension;
import com.github.dandelion.datatables.core.html.ExtraHtml;
import com.github.dandelion.datatables.core.html.HtmlHyperlink;
import com.github.dandelion.datatables.core.html.HtmlTable;

public class ExportFeature
extends AbstractExtension {
    private HtmlTable table;

    @Override
    public String getName() {
        return "export";
    }

    @Override
    public void setup(HtmlTable table) {
        this.table = table;
        for (ExportConf exportConf : table.getTableConfiguration().getExportConfiguration().values()) {
            if (!exportConf.getMethod().equals((Object)HttpMethod.POST) && !exportConf.getMethod().equals((Object)HttpMethod.PUT) && !exportConf.getMethod().equals((Object)HttpMethod.DELETE)) continue;
            this.addBundle(DatatableBundles.DDL_DT_EXPORT);
        }
        String exportContainerStyle = TableConfig.EXPORT_CONTAINER_STYLE.valueFrom(table);
        String exportContainerClass = TableConfig.EXPORT_CONTAINER_CLASS.valueFrom(table);
        ExtraHtml extraHtml = new ExtraHtml();
        extraHtml.setUid("E");
        extraHtml.setContainer("div");
        extraHtml.setCssClass("dataTables_export " + (StringUtils.isNotBlank((String)exportContainerClass) ? exportContainerClass : ""));
        extraHtml.setCssStyle(StringUtils.isNotBlank((String)exportContainerStyle) ? exportContainerStyle : "float: right;");
        String dom = TableConfig.FEATURE_DOM.valueFrom(table);
        if (StringUtils.isBlank((String)dom)) {
            this.addParameter("sDom", "lEfrtip", Parameter.Mode.OVERRIDE);
        }
        StringBuilder content = new StringBuilder();
        HtmlHyperlink link = null;
        for (ExportConf conf : table.getTableConfiguration().getExportConfiguration().values()) {
            link = new HtmlHyperlink();
            if (conf.getCssClass() != null) {
                link.setCssClass(conf.getCssClass());
            }
            if (conf.getCssStyle() != null) {
                link.setCssStyle(conf.getCssStyle());
                link.addCssStyle(";margin-left:2px;");
            } else {
                link.addCssStyle("margin-left:2px;");
            }
            if (conf.hasCustomUrl().booleanValue()) {
                link.setOnclick(this.getOnclick(conf));
            } else {
                link.setHref(conf.getUrl());
            }
            link.addContent(conf.getLabel());
            content.append((CharSequence)link.toHtml());
        }
        extraHtml.setContent(content.toString());
        this.appendToAfterStartDocumentReady("   ");
        this.appendToAfterStartDocumentReady(extraHtml.getJavascript().toString());
        this.appendToAfterStartDocumentReady("\n");
    }

    private String getOnclick(ExportConf exportConf) {
        String oTableId = "oTable_" + this.table.getId();
        String serverParamFunction = TableConfig.AJAX_SERVERPARAM.valueFrom(this.table);
        StringBuilder params = new StringBuilder();
        StringBuilder exportFuncName = new StringBuilder("ddl_dt_launch_export_");
        exportFuncName.append(this.table.getId());
        exportFuncName.append("_");
        exportFuncName.append(exportConf.getFormat());
        StringBuilder exportFunc = new StringBuilder("function ");
        exportFunc.append(exportFuncName.toString());
        exportFunc.append("(){").append('\n').append("   ");
        if (StringUtils.isNotBlank((String)serverParamFunction)) {
            params.append("aoData");
            exportFunc.append("var aoData = ").append(oTableId).append(".oApi._fnAjaxParameters(").append(oTableId).append(".fnSettings());").append('\n').append("   ");
            exportFunc.append(serverParamFunction).append("(aoData);").append('\n').append("   ");
            if (exportConf.getMethod().equals((Object)HttpMethod.GET)) {
                exportFunc.append("window.location=\"").append(exportConf.getUrl());
                if (exportConf.getUrl().contains("?")) {
                    exportFunc.append("&");
                } else {
                    exportFunc.append("?");
                }
                exportFunc.append("\" + decodeURIComponent($.param(").append(params.toString()).append(")).replace(/\\+/g,' ');").append('\n');
            } else {
                exportFunc.append("$.download('").append(exportConf.getUrl()).append("', decodeURIComponent($.param(").append(params.toString()).append(")).replace(/\\+/g,' '),'").append((Object)exportConf.getMethod()).append("');").append('\n');
            }
        } else {
            params.append(oTableId).append(".oApi._fnAjaxParameters(").append(oTableId).append(".fnSettings()");
            if (exportConf.getMethod().equals((Object)HttpMethod.GET)) {
                exportFunc.append("window.location=\"").append(exportConf.getUrl());
                if (exportConf.getUrl().contains("?")) {
                    exportFunc.append("&");
                } else {
                    exportFunc.append("?");
                }
                exportFunc.append("\" + decodeURIComponent($.param(").append(params.toString()).append(")).replace(/\\+/g,' '));").append('\n');
            } else {
                exportFunc.append("$.download('").append(exportConf.getUrl()).append("', decodeURIComponent($.param(").append(params.toString()).append(")).replace(/\\+/g,' '),'").append((Object)exportConf.getMethod()).append("'));").append('\n');
            }
        }
        exportFunc.append("}").append('\n');
        this.appendToBeforeAll(exportFunc.toString());
        return exportFuncName.append("();").toString();
    }
}

