/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.extension.feature;

import com.github.dandelion.core.utils.StringUtils;
import com.github.dandelion.datatables.core.configuration.TableConfig;
import com.github.dandelion.datatables.core.extension.AbstractExtension;
import com.github.dandelion.datatables.core.html.HtmlTable;

public class AppearFeature
extends AbstractExtension {
    @Override
    public String getName() {
        return "appear";
    }

    @Override
    public void setup(HtmlTable table) {
        String appear = TableConfig.FEATURE_APPEAR.valueFrom(table);
        String appearDuration = TableConfig.FEATURE_APPEAR_DURATION.valueFrom(table);
        if ("block".equals(appear)) {
            this.appendToBeforeEndDocumentReady("$('#" + table.getId() + "').show();");
        } else {
            table.addCssStyle("display:none;");
            if (StringUtils.isNotBlank((String)appearDuration)) {
                this.appendToBeforeEndDocumentReady("$('#" + table.getId() + "').fadeIn(" + appearDuration + ");");
            } else {
                this.appendToBeforeEndDocumentReady("$('#" + table.getId() + "').fadeIn();");
            }
        }
    }
}

