/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.extension.feature;

import com.github.dandelion.core.utils.StringUtils;
import com.github.dandelion.datatables.core.configuration.DatatableBundles;
import com.github.dandelion.datatables.core.configuration.TableConfig;
import com.github.dandelion.datatables.core.extension.AbstractExtension;
import com.github.dandelion.datatables.core.html.HtmlTable;

public class AjaxReloadFeature
extends AbstractExtension {
    @Override
    public String getName() {
        return "AjaxFeature";
    }

    @Override
    public void setup(HtmlTable table) {
        this.addBundle(DatatableBundles.DDL_DT_AJAX_RELOAD);
        String reloadSelector = TableConfig.AJAX_RELOAD_SELECTOR.valueFrom(table.getTableConfiguration());
        String reloadFunction = TableConfig.AJAX_RELOAD_FUNCTION.valueFrom(table.getTableConfiguration());
        StringBuilder js = new StringBuilder(10);
        if (StringUtils.isNotBlank((String)reloadFunction)) {
            js.append("$('").append(reloadSelector).append("').bind('click', function() {").append('\n').append("   ").append("   ");
            js.append(reloadFunction).append("();").append('\n').append("   ");
            js.append("});").append('\n');
        } else {
            js.append("$('").append(reloadSelector).append("').bind('click', function() {").append('\n').append("   ").append("   ");
            js.append("oTable_").append(table.getId()).append(".fnReloadAjax();").append('\n').append("   ");
            js.append("});").append('\n');
        }
        this.appendToBeforeEndDocumentReady(js.toString());
    }
}

