/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.extension;

import com.github.dandelion.core.utils.StringUtils;
import com.github.dandelion.datatables.core.asset.JsResource;
import com.github.dandelion.datatables.core.configuration.TableConfig;
import com.github.dandelion.datatables.core.exception.ExtensionLoadingException;
import com.github.dandelion.datatables.core.extension.AbstractExtension;
import com.github.dandelion.datatables.core.extension.Extension;
import com.github.dandelion.datatables.core.extension.ExtensionProcessor;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.util.ClassUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionLoader {
    private static Logger logger = LoggerFactory.getLogger(ExtensionLoader.class);
    private HtmlTable table;

    public ExtensionLoader(HtmlTable table) {
        this.table = table;
    }

    public void loadExtensions(JsResource mainJsFile, Map<String, Object> mainConf) {
        this.registerBuiltInExtensions(this.table);
        this.registerCustomExtensions(this.table);
        ExtensionProcessor extensionProcessor = new ExtensionProcessor(this.table, mainJsFile, mainConf);
        extensionProcessor.process(this.table.getTableConfiguration().getInternalExtensions());
        Extension theme = TableConfig.CSS_THEME.valueFrom(this.table);
        if (theme != null) {
            extensionProcessor.process(new HashSet<Extension>(Arrays.asList(theme)));
        }
    }

    private void registerBuiltInExtensions(HtmlTable table) {
        logger.debug("Scanning built-in extensions...");
        List<Extension> builtinExtensions = this.scanForExtensions("com.github.dandelion.datatables.core.extension.plugin", "com.github.dandelion.datatables.core.extension.theme");
        Set<String> extensionNames = TableConfig.MAIN_EXTENSION_NAMES.valueFrom(table);
        if (builtinExtensions != null && !builtinExtensions.isEmpty() && extensionNames != null && !extensionNames.isEmpty()) {
            for (String extensionToRegister : extensionNames) {
                for (Extension extension : builtinExtensions) {
                    if (!extensionToRegister.equalsIgnoreCase(extension.getName())) continue;
                    table.getTableConfiguration().registerExtension(extension);
                    logger.debug("Built-in extension {} registered", (Object)extension.getName());
                }
            }
        }
    }

    private void registerCustomExtensions(HtmlTable table) {
        String packageToScan = TableConfig.MAIN_EXTENSION_PACKAGE.valueFrom(table);
        if (StringUtils.isNotBlank((String)packageToScan)) {
            logger.debug("Scanning custom extensions...");
            List<Extension> customExtensions = this.scanForExtensions(packageToScan);
            Set<String> extensionNames = TableConfig.MAIN_EXTENSION_NAMES.valueFrom(table);
            if (customExtensions != null && !customExtensions.isEmpty() && extensionNames != null && !extensionNames.isEmpty()) {
                for (String extensionToRegister : extensionNames) {
                    for (Extension customExtension : customExtensions) {
                        if (!extensionToRegister.equals(customExtension.getName().toLowerCase())) continue;
                        table.getTableConfiguration().registerExtension(customExtension);
                        logger.debug("Custom extension '{}' registered", (Object)customExtension.getName());
                    }
                }
            } else {
                logger.warn("A base backage to scan has been detected ('" + packageToScan + "') but no custom extension has been found inside.");
            }
        }
    }

    private List<Extension> scanForExtensions(String ... packageNames) {
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        for (String packageName : packageNames) {
            extensions.addAll(this.scanForExtensions(packageName));
        }
        return extensions;
    }

    private List<Extension> scanForExtensions(String packageName) {
        ArrayList<Extension> retval = new ArrayList<Extension>();
        List<Class<?>> customExtensionClassList = null;
        try {
            customExtensionClassList = ClassUtils.getSubClassesInPackage(packageName, AbstractExtension.class);
        }
        catch (ClassNotFoundException e) {
            throw new ExtensionLoadingException("Unable to load extensions", e);
        }
        catch (IOException e) {
            throw new ExtensionLoadingException("Unable to access the package '" + packageName + "'", e);
        }
        for (Class<?> clazz : customExtensionClassList) {
            try {
                retval.add((AbstractExtension)ClassUtils.getClass(clazz.getName()).newInstance());
            }
            catch (InstantiationException e) {
                throw new ExtensionLoadingException("Unable to instanciate the class " + clazz.getName(), e);
            }
            catch (IllegalAccessException e) {
                throw new ExtensionLoadingException("Unable to access the class " + clazz.getName(), e);
            }
            catch (ClassNotFoundException e) {
                throw new ExtensionLoadingException("Unable to load the class " + clazz.getName(), e);
            }
        }
        return retval;
    }
}

