/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.extension;

import com.github.dandelion.core.Context;
import com.github.dandelion.core.web.AssetRequestContext;
import com.github.dandelion.datatables.core.asset.JavascriptFunction;
import com.github.dandelion.datatables.core.asset.Parameter;
import com.github.dandelion.datatables.core.callback.CallbackType;
import com.github.dandelion.datatables.core.configuration.ConfigToken;
import com.github.dandelion.datatables.core.configuration.DatatableBundles;
import com.github.dandelion.datatables.core.extension.Extension;
import com.github.dandelion.datatables.core.generator.configuration.AbstractConfigurationGenerator;
import com.github.dandelion.datatables.core.html.HtmlTable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;

public abstract class AbstractExtension
implements Extension {
    private String name = this.getName();
    private StringBuilder beforeAll;
    private StringBuilder beforeStartDocumentReady;
    private StringBuilder afterStartDocumentReady;
    private StringBuilder beforeEndDocumentReady;
    private StringBuilder afterAll;
    private List<Parameter> confs;
    private AbstractConfigurationGenerator configGenerator;
    private String function;
    private HtmlTable table;

    @Override
    public void setupWrapper(HtmlTable table) {
        this.table = table;
        this.setup(table);
    }

    public abstract void setup(HtmlTable var1);

    @Override
    public StringBuilder getBeforeAll() {
        return this.beforeAll;
    }

    @Override
    public StringBuilder getAfterAll() {
        return this.afterAll;
    }

    @Override
    public StringBuilder getBeforeStartDocumentReady() {
        return this.beforeStartDocumentReady;
    }

    @Override
    public StringBuilder getAfterStartDocumentReady() {
        return this.afterStartDocumentReady;
    }

    @Override
    public StringBuilder getBeforeEndDocumentReady() {
        return this.beforeEndDocumentReady;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.confs;
    }

    @Override
    public void setConfs(List<Parameter> confs) {
        this.confs = confs;
    }

    @Override
    public void addParameter(Parameter parameter) {
        if (this.confs == null) {
            this.confs = new ArrayList<Parameter>();
        }
        this.confs.add(parameter);
    }

    public void addParameter(String parameterName, Object parameterValue) {
        this.addParameter(new Parameter(parameterName, parameterValue));
    }

    public void addParameter(String parameterName, Object parameterValue, Parameter.Mode mode) {
        this.addParameter(new Parameter(parameterName, parameterValue, mode));
    }

    public void addBundle(DatatableBundles bundle) {
        AssetRequestContext.get((ServletRequest)this.table.getTableConfiguration().getRequest()).addBundles(new Enum[]{bundle});
    }

    public void addBundleParameter(String assetName, String paramName, Object paramValue) {
        AssetRequestContext.get((ServletRequest)this.table.getTableConfiguration().getRequest()).addParameter(assetName, paramName, paramValue);
    }

    public void addCallback(CallbackType callbackType, String javascript) {
        this.addParameter(new Parameter(callbackType.getName(), new JavascriptFunction(javascript, callbackType.getArgs()), Parameter.Mode.APPEND));
    }

    public void addCallback(CallbackType callbackType, String javascript, Parameter.Mode mode) {
        this.addParameter(new Parameter(callbackType.getName(), new JavascriptFunction(javascript, callbackType.getArgs()), mode));
    }

    @Override
    public AbstractConfigurationGenerator getConfigGenerator() {
        return this.configGenerator;
    }

    @Override
    public void setConfigGenerator(AbstractConfigurationGenerator configGenerator) {
        this.configGenerator = configGenerator;
    }

    @Override
    public void appendToBeforeAll(String beforeAll) {
        if (this.beforeAll == null) {
            this.beforeAll = new StringBuilder();
        }
        this.beforeAll.append(beforeAll);
    }

    @Override
    public void appendToBeforeStartDocumentReady(String beforeStartDocumentReady) {
        if (this.beforeStartDocumentReady == null) {
            this.beforeStartDocumentReady = new StringBuilder();
        }
        this.beforeStartDocumentReady.append(beforeStartDocumentReady);
    }

    @Override
    public void appendToAfterStartDocumentReady(String afterStartDocumentReady) {
        if (this.afterStartDocumentReady == null) {
            this.afterStartDocumentReady = new StringBuilder();
        }
        this.afterStartDocumentReady.append(afterStartDocumentReady);
    }

    @Override
    public void appendToBeforeEndDocumentReady(String beforeEndDocumentReady) {
        if (this.beforeEndDocumentReady == null) {
            this.beforeEndDocumentReady = new StringBuilder();
        }
        this.beforeEndDocumentReady.append(beforeEndDocumentReady);
    }

    @Override
    public void appendToAfterAll(String afterAll) {
        if (this.afterAll == null) {
            this.afterAll = new StringBuilder();
        }
        this.afterAll.append(afterAll);
    }

    @Override
    public String getFunction() {
        return this.function;
    }

    @Override
    public void setFunction(String function) {
        this.function = function;
    }

    public Map<String, String> getDynamicAttributes() {
        return this.table.getDynamicAttributes();
    }

    public boolean isEnabled(ConfigToken<Boolean> configToken) {
        Boolean result = configToken.valueFrom(this.table.getTableConfiguration());
        if (result != null) {
            // empty if block
        }
        return true;
    }

    public boolean isNotNull(ConfigToken<?> configToken) {
        Object result = configToken.valueFrom(this.table.getTableConfiguration());
        return result != null;
    }

    public Context getContext() {
        Context context = (Context)this.table.getTableConfiguration().getRequest().getAttribute("dandelionContext");
        return context;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractExtension other = (AbstractExtension)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.table == null ? other.table != null : !this.table.equals(other.table));
    }
}

