/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.export;

import com.github.dandelion.core.utils.StringUtils;
import com.github.dandelion.datatables.core.configuration.TableConfig;
import com.github.dandelion.datatables.core.exception.ExportException;
import com.github.dandelion.datatables.core.export.DatatablesExport;
import com.github.dandelion.datatables.core.export.ExportConf;
import com.github.dandelion.datatables.core.html.HtmlColumn;
import com.github.dandelion.datatables.core.html.HtmlRow;
import com.github.dandelion.datatables.core.html.HtmlTable;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XmlExport
implements DatatablesExport {
    private HtmlTable table;
    private ExportConf exportConf;

    @Override
    public void initExport(HtmlTable table) {
        this.table = table;
        this.exportConf = table.getTableConfiguration().getExportConfiguration().get("xml");
    }

    @Override
    public void processExport(OutputStream output) {
        ArrayList<String> headers = new ArrayList<String>();
        for (HtmlRow row : this.table.getHeadRows()) {
            for (HtmlColumn column : row.getColumns("all", "xml")) {
                headers.add(StringUtils.uncapitalize((String)column.getContent().toString()));
            }
        }
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = null;
        String objectType = TableConfig.INTERNAL_OBJECTTYPE.valueFrom(this.table.getTableConfiguration()).toLowerCase();
        try {
            writer = outputFactory.createXMLStreamWriter(output);
            writer.writeStartDocument("1.0");
            writer.writeStartElement(objectType + "s");
            for (HtmlRow row : this.table.getBodyRows()) {
                writer.writeStartElement(objectType);
                int i = 0;
                for (HtmlColumn column : row.getColumns("all", "xml")) {
                    writer.writeAttribute((String)headers.get(i), column.getContent().toString());
                    ++i;
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
        }
        catch (XMLStreamException e) {
            StringBuilder sb = new StringBuilder("Something went wrong during the XML generation of the table '");
            sb.append(this.table.getOriginalId());
            sb.append("' and with the following export configuration: ");
            sb.append(this.exportConf.toString());
            throw new ExportException(sb.toString(), e);
        }
        finally {
            try {
                writer.close();
            }
            catch (XMLStreamException e) {
                StringBuilder sb = new StringBuilder("Something went wrong during the XML generation of the table '");
                sb.append(this.table.getOriginalId());
                sb.append("' and with the following export configuration: ");
                sb.append(this.exportConf.toString());
                throw new ExportException(sb.toString(), e);
            }
        }
    }
}

