/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.export;

import com.github.dandelion.core.utils.StringUtils;
import com.github.dandelion.datatables.core.configuration.ColumnConfig;
import com.github.dandelion.datatables.core.configuration.TableConfig;
import com.github.dandelion.datatables.core.export.ColumnElement;
import com.github.dandelion.datatables.core.export.ExportConf;
import com.github.dandelion.datatables.core.html.HtmlColumn;
import com.github.dandelion.datatables.core.html.HtmlTable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlTableBuilder<T> {
    private static Logger logger = LoggerFactory.getLogger(HtmlTableBuilder.class);

    public ColumnStep newBuilder(String id, List<T> data, HttpServletRequest request) {
        return new Steps<T>(id, data, request);
    }

    public ColumnStep newBuilder(String id, List<T> data, HttpServletRequest request, ExportConf exportConf) {
        return new Steps<T>(id, data, request, exportConf);
    }

    private static class Steps<T>
    implements ColumnStep,
    FirstContentStep,
    SecondContentStep,
    BuildStep {
        private String id;
        private List<T> data;
        private LinkedList<HtmlColumn> headerColumns = new LinkedList();
        private HttpServletRequest request;
        private HttpServletResponse response;
        private ExportConf exportConf;

        public Steps(String id, List<T> data, HttpServletRequest request) {
            this(id, data, request, null);
        }

        public Steps(String id, List<T> data, HttpServletRequest request, ExportConf exportConf) {
            this.id = id;
            this.data = data;
            this.request = request;
            this.exportConf = new ExportConf(request);
            if (exportConf != null) {
                this.exportConf.mergeWith(exportConf);
            }
        }

        @Override
        public Steps<T> column() {
            HtmlColumn column = new HtmlColumn(true, "");
            this.headerColumns.add(column);
            return this;
        }

        @Override
        public Steps<T> title(String title) {
            ColumnConfig.TITLE.setIn(this.headerColumns.getLast().getColumnConfiguration(), title);
            return this;
        }

        @Override
        public Steps<T> fillWithProperty(String property) {
            return this.fillWithProperty(property, null, "");
        }

        @Override
        public Steps<T> fillWithProperty(String property, String pattern) {
            return this.fillWithProperty(property, pattern, "");
        }

        @Override
        public Steps<T> fillWithProperty(String property, String pattern, String defaultContent) {
            if (this.headerColumns.getLast().getColumnConfiguration().getColumnElements() == null) {
                this.headerColumns.getLast().getColumnConfiguration().setColumnElements(new ArrayList<ColumnElement>());
            }
            this.headerColumns.getLast().getColumnConfiguration().getColumnElements().add(new ColumnElement(property, pattern, "", defaultContent));
            return this;
        }

        @Override
        public Steps<T> fillWith(String content) {
            if (this.headerColumns.getLast().getColumnConfiguration().getColumnElements() == null) {
                this.headerColumns.getLast().getColumnConfiguration().setColumnElements(new ArrayList<ColumnElement>());
            }
            this.headerColumns.getLast().getColumnConfiguration().getColumnElements().add(new ColumnElement(null, null, content, null));
            return this;
        }

        @Override
        public Steps<T> andProperty(String property) {
            return this.andProperty(property, null, "");
        }

        @Override
        public Steps<T> andProperty(String property, String pattern) {
            return this.andProperty(property, pattern, "");
        }

        @Override
        public Steps<T> andProperty(String property, String pattern, String defaultContent) {
            if (this.headerColumns.getLast().getColumnConfiguration().getColumnElements() == null) {
                this.headerColumns.getLast().getColumnConfiguration().setColumnElements(new ArrayList<ColumnElement>());
            }
            this.headerColumns.getLast().getColumnConfiguration().getColumnElements().add(new ColumnElement(property, pattern, null, defaultContent));
            return this;
        }

        @Override
        public Steps<T> and(String content) {
            if (this.headerColumns.getLast().getColumnConfiguration().getColumnElements() == null) {
                this.headerColumns.getLast().getColumnConfiguration().setColumnElements(new ArrayList<ColumnElement>());
            }
            this.headerColumns.getLast().getColumnConfiguration().getColumnElements().add(new ColumnElement(null, null, content, null));
            return this;
        }

        @Override
        public HtmlTable build() {
            HtmlTable table = new HtmlTable(this.id, this.request, this.response);
            table.getTableConfiguration().getExportConfiguration().put(this.exportConf.getFormat(), this.exportConf);
            if (this.data != null && this.data.size() > 0) {
                TableConfig.INTERNAL_OBJECTTYPE.setIn(table.getTableConfiguration(), this.data.get(0).getClass().getSimpleName());
            } else {
                TableConfig.INTERNAL_OBJECTTYPE.setIn(table.getTableConfiguration(), "???");
            }
            table.addHeaderRow();
            for (HtmlColumn column : this.headerColumns) {
                String title = ColumnConfig.TITLE.valueFrom(column.getColumnConfiguration());
                if (StringUtils.isNotBlank((String)title)) {
                    column.setContent(new StringBuilder(title));
                } else {
                    column.setContent(new StringBuilder(""));
                }
                table.getLastHeaderRow().addColumn(column);
            }
            if (this.data != null) {
                for (Object o : this.data) {
                    table.addRow();
                    for (HtmlColumn column : this.headerColumns) {
                        String content = "";
                        for (ColumnElement columnElement : column.getColumnConfiguration().getColumnElements()) {
                            if (StringUtils.isNotBlank((String)columnElement.getPropertyName())) {
                                try {
                                    Object tmpObject = PropertyUtils.getNestedProperty((Object)o, (String)columnElement.getPropertyName().trim());
                                    if (StringUtils.isNotBlank((String)columnElement.getPattern())) {
                                        MessageFormat messageFormat = new MessageFormat(columnElement.getPattern());
                                        content = content + messageFormat.format(new Object[]{tmpObject});
                                        continue;
                                    }
                                    content = content + String.valueOf(tmpObject);
                                }
                                catch (Exception e) {
                                    logger.warn("Something went wrong with the property {}. Check that an accessor method for this property exists in the bean.");
                                    content = content + columnElement.getDefaultValue();
                                }
                                continue;
                            }
                            if (columnElement.getContent() != null) {
                                content = content + columnElement.getContent();
                                continue;
                            }
                            content = content + columnElement.getDefaultValue();
                        }
                        table.getLastBodyRow().addColumn(String.valueOf(content));
                    }
                }
            }
            return table;
        }
    }

    public static interface BuildStep {
        public HtmlTable build();

        public FirstContentStep column();
    }

    public static interface TitleStep
    extends ColumnStep {
        public ColumnStep title(String var1);
    }

    public static interface SecondContentStep {
        public SecondContentStep andProperty(String var1);

        public SecondContentStep andProperty(String var1, String var2);

        public SecondContentStep andProperty(String var1, String var2, String var3);

        public SecondContentStep and(String var1);

        public BuildStep title(String var1);
    }

    public static interface FirstContentStep {
        public SecondContentStep fillWithProperty(String var1);

        public SecondContentStep fillWithProperty(String var1, String var2);

        public SecondContentStep fillWithProperty(String var1, String var2, String var3);

        public SecondContentStep fillWith(String var1);
    }

    public static interface ColumnStep {
        public FirstContentStep column();
    }
}

