/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.configuration;

import com.github.dandelion.core.utils.ClassUtils;
import com.github.dandelion.core.utils.StringUtils;
import com.github.dandelion.datatables.core.configuration.ConfigurationLoader;
import com.github.dandelion.datatables.core.configuration.StandardConfigurationLoader;
import com.github.dandelion.datatables.core.exception.ConfigurationLoadingException;
import com.github.dandelion.datatables.core.generator.javascript.JavascriptGenerator;
import com.github.dandelion.datatables.core.generator.javascript.StandardJavascriptGenerator;
import com.github.dandelion.datatables.core.i18n.LocaleResolver;
import com.github.dandelion.datatables.core.i18n.MessageResolver;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatatablesConfigurator {
    private static Logger logger = LoggerFactory.getLogger(DatatablesConfigurator.class);
    private static ConfigurationLoader configurationLoader;
    private static LocaleResolver localeResolver;
    private static MessageResolver messageResolver;

    public static LocaleResolver getLocaleResolver() {
        block9: {
            Properties userProperties = null;
            String className = null;
            ConfigurationLoader configurationLoader = DatatablesConfigurator.getConfigurationLoader();
            if (localeResolver == null) {
                try {
                    userProperties = configurationLoader.loadUserConfiguration(Locale.getDefault());
                    if (userProperties != null) {
                        try {
                            className = userProperties.getProperty("i18n.locale.resolver");
                        }
                        catch (MissingResourceException e) {
                            logger.debug("No custom LocaleResolver has been configured. Using default one.");
                        }
                    }
                    if (className == null) {
                        Properties defaultProperties = configurationLoader.loadDefaultConfiguration();
                        className = defaultProperties.getProperty("i18n.locale.resolver");
                    }
                    if (className == null) break block9;
                    try {
                        Class classProperty = ClassUtils.getClass((String)className);
                        localeResolver = (LocaleResolver)ClassUtils.getNewInstance((Class)classProperty);
                    }
                    catch (Exception e) {
                        throw new ConfigurationLoadingException(e);
                    }
                }
                catch (ConfigurationLoadingException e) {
                    throw new ConfigurationLoadingException("Unable to retrieve the LocaleResolver using the class '" + className + "'", e);
                }
            }
        }
        return localeResolver;
    }

    public static MessageResolver getMessageResolver(HttpServletRequest request) {
        block9: {
            Properties userProperties = null;
            String className = null;
            ConfigurationLoader configurationLoader = DatatablesConfigurator.getConfigurationLoader();
            if (messageResolver == null) {
                try {
                    userProperties = configurationLoader.loadUserConfiguration(Locale.getDefault());
                    if (userProperties != null) {
                        try {
                            className = userProperties.getProperty("i18n.message.resolver");
                        }
                        catch (MissingResourceException e) {
                            logger.debug("No custom MessageResolver has been configured. Using default one.");
                        }
                    }
                    if (className == null) {
                        Properties defaultProperties = configurationLoader.loadDefaultConfiguration();
                        className = defaultProperties.getProperty("i18n.message.resolver");
                    }
                    if (className == null) break block9;
                    try {
                        Class classProperty = ClassUtils.getClass((String)className);
                        messageResolver = (MessageResolver)classProperty.getDeclaredConstructor(HttpServletRequest.class).newInstance(request);
                    }
                    catch (Exception e) {
                        throw new ConfigurationLoadingException(e);
                    }
                }
                catch (ConfigurationLoadingException e) {
                    throw new ConfigurationLoadingException("Unable to retrieve the MessageResolver using the class '" + className + "'", e);
                }
            }
        }
        return messageResolver;
    }

    public static ConfigurationLoader getConfigurationLoader() {
        if (configurationLoader == null) {
            logger.debug("Initializing the configuration loader...");
            if (StringUtils.isNotBlank((String)System.getProperty("dandelion.datatables.confloader.class"))) {
                try {
                    Class clazz = ClassUtils.getClass((String)System.getProperty("dandelion.datatables.confloader.class"));
                    configurationLoader = (ConfigurationLoader)ClassUtils.getNewInstance((Class)clazz);
                }
                catch (Exception e) {
                    logger.warn("Unable to instantiate the configured {} due to a {} exception. Falling back to the default one.", new Object[]{"dandelion.datatables.confloader.class", e.getClass().getName(), e});
                }
            }
            if (configurationLoader == null) {
                configurationLoader = new StandardConfigurationLoader();
            }
        }
        return configurationLoader;
    }

    public static JavascriptGenerator getJavascriptGenerator() {
        logger.debug("Initializing the Javascript generator...");
        JavascriptGenerator javascriptGenerator = null;
        if (StringUtils.isNotBlank((String)System.getProperty("dandelion.datatables.js.generator.class"))) {
            try {
                Class clazz = ClassUtils.getClass((String)System.getProperty("dandelion.datatables.js.generator.class"));
                javascriptGenerator = (JavascriptGenerator)ClassUtils.getNewInstance((Class)clazz);
            }
            catch (Exception e) {
                logger.warn("Unable to instantiate the configured {} due to a {} exception. Falling back to the default one.", new Object[]{"dandelion.datatables.js.generator.class", e.getClass().getName(), e});
            }
        }
        if (javascriptGenerator == null) {
            javascriptGenerator = new StandardJavascriptGenerator();
        }
        return javascriptGenerator;
    }

    public static void clear() {
        configurationLoader = null;
        localeResolver = null;
    }
}

