/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.configuration;

import com.github.dandelion.core.Context;
import com.github.dandelion.core.utils.StringUtils;
import com.github.dandelion.datatables.core.configuration.ConfigToken;
import com.github.dandelion.datatables.core.configuration.ConfigurationLoader;
import com.github.dandelion.datatables.core.configuration.DatatablesConfigurator;
import com.github.dandelion.datatables.core.configuration.TableConfiguration;
import com.github.dandelion.datatables.core.exception.UnkownGroupException;
import com.github.dandelion.datatables.core.i18n.MessageResolver;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationStore {
    private static Logger LOGGER = LoggerFactory.getLogger(ConfigurationStore.class);
    private static Map<Locale, Map<String, Map<ConfigToken<?>, Object>>> configurationStore = new HashMap();

    public static TableConfiguration getPrototype(HttpServletRequest request, String groupName) {
        Locale locale = null;
        String group = StringUtils.isBlank((String)groupName) ? "global" : groupName;
        locale = request != null ? DatatablesConfigurator.getLocaleResolver().resolveLocale(request) : Locale.getDefault();
        Context context = (Context)request.getAttribute("dandelionContext");
        if (context == null) {
            LOGGER.warn("The Dandelion context doesn't seem to be available. Did you forget to declare the DandelionFilter in your web.xml file?");
        } else if (context.isDevModeEnabled()) {
            ConfigurationStore.clear();
        }
        if (!configurationStore.containsKey(locale)) {
            ConfigurationStore.resolveGroupsForLocale(locale, request);
        }
        if (!configurationStore.get(locale).containsKey(group)) {
            StringBuilder msg = new StringBuilder("The group '");
            msg.append(group);
            msg.append("' doesn't exist in your configuration files. Either create it or choose an existing one among ");
            msg.append(configurationStore.get(locale).keySet());
            throw new UnkownGroupException(msg.toString());
        }
        MessageResolver messageResolver = DatatablesConfigurator.getMessageResolver(request);
        return new TableConfiguration(configurationStore.get(locale).get(group), messageResolver, request);
    }

    public static void resolveGroupsForLocale(Locale locale, HttpServletRequest request) {
        HashMap map = new HashMap();
        ConfigurationLoader confLoader = DatatablesConfigurator.getConfigurationLoader();
        confLoader.loadDefaultConfiguration();
        confLoader.loadUserConfiguration(locale);
        confLoader.resolveGroups(locale);
        confLoader.resolveConfigurations(map, locale, request);
        configurationStore.put(locale, map);
    }

    public static Map<Locale, Map<String, Map<ConfigToken<?>, Object>>> getConfigurationStore() {
        return configurationStore;
    }

    public static void clear() {
        configurationStore.clear();
    }
}

