/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.configuration;

import com.github.dandelion.core.utils.StringUtils;
import com.github.dandelion.datatables.core.configuration.ColumnConfiguration;
import com.github.dandelion.datatables.core.configuration.TableConfiguration;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.processor.ConfigurationProcessor;
import java.util.Map;

public class ConfigToken<T> {
    private String propertyName;
    private ConfigurationProcessor processor;

    public ConfigToken(String propertyName, ConfigurationProcessor processor) {
        this.propertyName = propertyName;
        this.processor = processor;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public ConfigurationProcessor getProcessor() {
        return this.processor;
    }

    public T valueFrom(Map<ConfigToken<?>, Object> configurations) {
        return (T)configurations.get(this);
    }

    public T valueFrom(TableConfiguration tableConfiguration) {
        if (tableConfiguration.getConfigurations() != null) {
            return (T)tableConfiguration.getConfigurations().get(this);
        }
        return null;
    }

    public T valueFrom(ColumnConfiguration columnConfiguration) {
        return (T)columnConfiguration.getConfigurations().get(this);
    }

    public T valueFrom(HtmlTable table) {
        if (table.getTableConfiguration().getConfigurations() != null) {
            return (T)table.getTableConfiguration().getConfigurations().get(this);
        }
        return null;
    }

    public void setIn(ColumnConfiguration columnConfiguration, T value) {
        columnConfiguration.getConfigurations().put(this, value);
    }

    public void setIn(TableConfiguration tableConfiguration, T value) {
        tableConfiguration.getConfigurations().put(this, value);
    }

    public void appendIn(TableConfiguration tableConfiguration, String value) {
        Object existingValue = tableConfiguration.getConfigurations().get(this);
        if (existingValue != null) {
            ((StringBuilder)existingValue).append(value);
        } else {
            tableConfiguration.getConfigurations().put(this, new StringBuilder(value));
        }
    }

    public void toto() {
    }

    public void appendIn(TableConfiguration tableConfiguration, char value) {
        tableConfiguration.getConfigurations().put(this, ((StringBuilder)tableConfiguration.getConfigurations().get(this)).append(value));
    }

    public void appendIn(ColumnConfiguration columnConfiguration, String value) {
        this.doAppendIn(columnConfiguration, value);
    }

    public void appendIn(ColumnConfiguration columnConfiguration, char value) {
        this.doAppendIn(columnConfiguration, String.valueOf(value));
    }

    private void doAppendIn(ColumnConfiguration columnConfiguration, String value) {
        Object existingValue = columnConfiguration.getConfigurations().get(this);
        if (StringUtils.isNotBlank((String)value)) {
            if (existingValue != null) {
                ((StringBuilder)existingValue).append(value);
            } else {
                columnConfiguration.getConfigurations().put(this, new StringBuilder(value));
            }
        }
    }

    public void setIn(T value, HtmlTable table) {
        table.getTableConfiguration().getConfigurations().put(this, value);
    }

    public String toString() {
        return "['" + this.propertyName + "' / " + this.processor.getClass().getSimpleName() + "]";
    }
}

