/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.configuration;

import com.github.dandelion.datatables.core.configuration.ConfigToken;
import com.github.dandelion.datatables.core.constants.Direction;
import com.github.dandelion.datatables.core.extension.Extension;
import com.github.dandelion.datatables.core.extension.feature.FilterType;
import com.github.dandelion.datatables.core.html.HtmlColumn;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.processor.BooleanProcessor;
import com.github.dandelion.datatables.core.processor.ConfigurationProcessor;
import com.github.dandelion.datatables.core.processor.EmptyStringProcessor;
import com.github.dandelion.datatables.core.processor.IntegerProcessor;
import com.github.dandelion.datatables.core.processor.StringBuilderProcessor;
import com.github.dandelion.datatables.core.processor.StringProcessor;
import com.github.dandelion.datatables.core.processor.column.FilterTypeProcessor;
import com.github.dandelion.datatables.core.processor.column.FilterableProcessor;
import com.github.dandelion.datatables.core.processor.column.SortDirectionProcessor;
import com.github.dandelion.datatables.core.processor.column.SortTypeProcessor;
import java.util.List;
import java.util.Map;

public final class ColumnConfig {
    public static ConfigToken<String> ID = new ConfigToken("", new StringProcessor());
    public static ConfigToken<String> TITLE = new ConfigToken("", new StringProcessor());
    public static ConfigToken<String> TITLEKEY = new ConfigToken("", new StringProcessor());
    public static ConfigToken<String> NAME = new ConfigToken("", new StringProcessor());
    public static ConfigToken<String> PROPERTY = new ConfigToken("", new StringProcessor());
    public static ConfigToken<String> DEFAULTVALUE = new ConfigToken("", new EmptyStringProcessor());
    public static ConfigToken<StringBuilder> CSSSTYLE = new ConfigToken("", new StringBuilderProcessor());
    public static ConfigToken<StringBuilder> CSSCELLSTYLE = new ConfigToken("", new StringBuilderProcessor());
    public static ConfigToken<StringBuilder> CSSCLASS = new ConfigToken("", new StringBuilderProcessor());
    public static ConfigToken<StringBuilder> CSSCELLCLASS = new ConfigToken("", new StringBuilderProcessor());
    public static ConfigToken<Boolean> SORTABLE = new ConfigToken("", new BooleanProcessor());
    public static ConfigToken<List<Direction>> SORTDIRECTION = new ConfigToken("", new SortDirectionProcessor());
    public static ConfigToken<String> SORTINITDIRECTION = new ConfigToken("", new StringProcessor());
    public static ConfigToken<Integer> SORTINITORDER = new ConfigToken("", new IntegerProcessor());
    public static ConfigToken<String> SORTTYPE = new ConfigToken("", new SortTypeProcessor(true));
    public static ConfigToken<Boolean> FILTERABLE = new ConfigToken("", new FilterableProcessor());
    public static ConfigToken<Boolean> SEARCHABLE = new ConfigToken("", new BooleanProcessor());
    public static ConfigToken<Boolean> VISIBLE = new ConfigToken("", new BooleanProcessor());
    public static ConfigToken<FilterType> FILTERTYPE = new ConfigToken("", new FilterTypeProcessor());
    public static ConfigToken<String> FILTERDATEFORMAT = new ConfigToken("", new StringProcessor());
    public static ConfigToken<String> FILTERVALUES = new ConfigToken("", new StringProcessor(true));
    public static ConfigToken<String> FILTERCSSCLASS = new ConfigToken("", new StringProcessor());
    public static ConfigToken<String> FILTERPLACEHOLDER = new ConfigToken("", new StringProcessor());
    public static ConfigToken<Integer> FILTERMINLENGTH = new ConfigToken("", new IntegerProcessor());
    public static ConfigToken<String> RENDERFUNCTION = new ConfigToken("", new StringProcessor(true));
    public static ConfigToken<String> SELECTOR = new ConfigToken("", new StringProcessor());

    public static void applyConfiguration(Map<ConfigToken<?>, Object> stagingConf, Map<ConfigToken<?>, Extension> stagingExtensions, HtmlColumn column) {
        for (Map.Entry<ConfigToken<?>, Object> stagingEntry : stagingConf.entrySet()) {
            column.getColumnConfiguration().getConfigurations().put(stagingEntry.getKey(), stagingEntry.getValue());
        }
        column.getColumnConfiguration().getStagingExtension().putAll(stagingExtensions);
    }

    public static void processConfiguration(HtmlColumn column, HtmlTable table) {
        if (column.getColumnConfiguration().getConfigurations() != null) {
            for (Map.Entry<ConfigToken<?>, Object> entry : column.getColumnConfiguration().getConfigurations().entrySet()) {
                ConfigurationProcessor columnProcessor = entry.getKey().getProcessor();
                columnProcessor.process(entry, column.getColumnConfiguration(), table.getTableConfiguration());
            }
            column.getColumnConfiguration().getConfigurations().putAll(column.getColumnConfiguration().getStagingConfigurations());
        }
    }

    private ColumnConfig() {
    }
}

