/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.ajax;

import com.github.dandelion.core.utils.StringUtils;
import com.github.dandelion.datatables.core.ajax.ColumnDef;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class DatatablesCriterias
implements Serializable {
    private static final long serialVersionUID = 8661357461501153387L;
    private String search;
    private Integer displayStart;
    private Integer displaySize;
    private List<ColumnDef> columnDefs;
    private List<ColumnDef> sortingColumnDefs;
    private Integer internalCounter;

    public DatatablesCriterias() {
    }

    public DatatablesCriterias(String search, Integer displayStart, Integer displaySize, List<ColumnDef> columnDefs, List<ColumnDef> sortingColumnDefs, Integer internalCounter) {
        this.search = search;
        this.displayStart = displayStart;
        this.displaySize = displaySize;
        this.columnDefs = columnDefs;
        this.sortingColumnDefs = sortingColumnDefs;
        this.internalCounter = internalCounter;
    }

    public Integer getDisplayStart() {
        return this.displayStart;
    }

    public Integer getDisplaySize() {
        return this.displaySize;
    }

    public String getSearch() {
        return this.search;
    }

    public Integer getInternalCounter() {
        return this.internalCounter;
    }

    public List<ColumnDef> getColumnDefs() {
        return this.columnDefs;
    }

    public List<ColumnDef> getSortingColumnDefs() {
        return this.sortingColumnDefs;
    }

    public Boolean hasOneFilterableColumn() {
        for (ColumnDef columnDef : this.columnDefs) {
            if (!columnDef.isFilterable()) continue;
            return true;
        }
        return false;
    }

    public Boolean hasOneFilteredColumn() {
        for (ColumnDef columnDef : this.columnDefs) {
            if (!StringUtils.isNotBlank((String)columnDef.getSearch()) && !StringUtils.isNotBlank((String)columnDef.getSearchFrom()) && !StringUtils.isNotBlank((String)columnDef.getSearchTo())) continue;
            return true;
        }
        return false;
    }

    public Boolean hasOneSortedColumn() {
        return !this.sortingColumnDefs.isEmpty();
    }

    public static DatatablesCriterias getFromRequest(HttpServletRequest request) {
        if (request != null) {
            int i;
            String sSearch = request.getParameter("sSearch");
            String sEcho = request.getParameter("sEcho");
            String sDisplayStart = request.getParameter("iDisplayStart");
            String sDisplayLength = request.getParameter("iDisplayLength");
            String sColNumber = request.getParameter("iColumns");
            String sSortingColNumber = request.getParameter("iSortingCols");
            Integer iEcho = StringUtils.isNotBlank((String)sEcho) ? Integer.parseInt(sEcho) : -1;
            Integer iDisplayStart = StringUtils.isNotBlank((String)sDisplayStart) ? Integer.parseInt(sDisplayStart) : -1;
            Integer iDisplayLength = StringUtils.isNotBlank((String)sDisplayLength) ? Integer.parseInt(sDisplayLength) : -1;
            Integer colNumber = StringUtils.isNotBlank((String)sColNumber) ? Integer.parseInt(sColNumber) : -1;
            Integer sortingColNumber = StringUtils.isNotBlank((String)sSortingColNumber) ? Integer.parseInt(sSortingColNumber) : -1;
            ArrayList<ColumnDef> columnDefs = new ArrayList<ColumnDef>();
            LinkedList<ColumnDef> sortingColumnDefs = new LinkedList<ColumnDef>();
            for (i = 0; i < colNumber; ++i) {
                ColumnDef columnDef = new ColumnDef();
                columnDef.setName(request.getParameter("mDataProp_" + i));
                columnDef.setFilterable(Boolean.parseBoolean(request.getParameter("bSearchable_" + i)));
                columnDef.setSortable(Boolean.parseBoolean(request.getParameter("bSortable_" + i)));
                String columnSearch = request.getParameter("sSearch_" + i);
                if (StringUtils.isNotBlank((String)columnSearch)) {
                    String[] splittedSearch = columnSearch.split("~");
                    if ("~".equals(columnSearch)) {
                        columnDef.setSearch("");
                    } else if (columnSearch.startsWith("~")) {
                        columnDef.setSearchTo(splittedSearch[1]);
                    } else if (columnSearch.endsWith("~")) {
                        columnDef.setSearchFrom(splittedSearch[0]);
                    } else if (columnSearch.contains("~")) {
                        columnDef.setSearchFrom(splittedSearch[0]);
                        columnDef.setSearchTo(splittedSearch[1]);
                    } else {
                        columnDef.setSearch(columnSearch);
                    }
                }
                columnDefs.add(columnDef);
            }
            for (i = 0; i < sortingColNumber; ++i) {
                String sSortingCol = request.getParameter("iSortCol_" + i);
                Integer sortingCol = StringUtils.isNotBlank((String)sSortingCol) ? Integer.parseInt(sSortingCol) : -1;
                ColumnDef sortedColumnDef = (ColumnDef)columnDefs.get(sortingCol);
                String sortingColDirection = request.getParameter("sSortDir_" + i);
                if (StringUtils.isNotBlank((String)sortingColDirection)) {
                    sortedColumnDef.setSortDirection(ColumnDef.SortDirection.valueOf(sortingColDirection.toUpperCase()));
                }
                sortingColumnDefs.add(sortedColumnDef);
            }
            return new DatatablesCriterias(sSearch, iDisplayStart, iDisplayLength, columnDefs, sortingColumnDefs, iEcho);
        }
        return null;
    }

    public String toString() {
        return "DatatablesCriterias [search=" + this.search + ", displayStart=" + this.displayStart + ", displaySize=" + this.displaySize + ", columnDefs=" + this.columnDefs + ", sortingColumnDefs=" + this.sortingColumnDefs + ", internalCounter=" + this.internalCounter + "]";
    }
}

