package com.firefly.iview;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import java.util.HashMap;
import java.util.Map;

@Data
public class Layout {

    private String type;

    /**
     * 其他属性,
     * 组件衍生: 如Button onClick
     */
    @JsonIgnore
    private Map<String, Object> attributes = new HashMap<>();


    @JsonAnyGetter
    public Map<String, Object> other() {
        return this.attributes;
    }

    @JsonAnySetter
    public void setOther(String key, Object value) {
        this.attributes.put(key, value);
    }

}
