package com.firefly.iview.document;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Data;

import java.util.List;


@JsonTypeInfo(
        use = JsonTypeInfo.Id.NAME,
        include = JsonTypeInfo.As.EXISTING_PROPERTY,
        property = "type",
        visible = true
)
@JsonSubTypes({
        @JsonSubTypes.Type(value = BackgroundDocument.class, name = "BACKGROUND"),
        @JsonSubTypes.Type(value = ImageDocument.class, name = "background"),
        @JsonSubTypes.Type(value = ElementDocument.class, name = "ELEMENT"),
        @JsonSubTypes.Type(value = ImageDocument.class, name = "element"),
        @JsonSubTypes.Type(value = ImageDocument.class, name = "IMAGE"),
        @JsonSubTypes.Type(value = ImageDocument.class, name = "image"),
        @JsonSubTypes.Type(value = PageDocument.class, name = "PAGE"),
        @JsonSubTypes.Type(value = PageDocument.class, name = "page/concat"),
        @JsonSubTypes.Type(value = PageDocument.class, name = "page/turn"),
})
@Data
public class Document {

//    private DocumentSchema schema;
    private String schema;

    private String type;

    //字体引用
    private List<FontFace> fonts;

    //图片素材资源引用
}
