package com.firefly.iview;

import lombok.Data;

import java.time.Instant;
import java.util.Map;

@Data
public class Censor {

    private String id;

    /**
     * 区分资源
     */
    private String namespace;

    private String targetResource;

    private String targetId;
    //状态
    private AuditState state;

    //拒绝原因
    private String reason;

    //审核时间
    private Instant auditedAt;

    /**
     * 冗余扩展数据
     */
    private Map<String, String> metadata;


    private Instant updatedAt;


    private Instant createdAt;

    public static enum AuditState {
        //等待
        PENDING,
        //审核通过
        PASS,
        //拒绝
        REJECT,
    }
}
