package com.firefly.iview.document;

import com.firefly.iview.Element;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * 页面-文档
 * - logo设计
 *
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class PageDocument extends Document {


    //默认标准  转为viewport width 按比展示
    private Integer width = 750;

    private Integer height;

//    private String backgroundColor;

    private Background background;

    private Music backgroundMusic;

    /**
     * @deprecated 废除
     */
    @Deprecated()
    private List<Element> elements;

    private PageType pageType;

    private List<PageLayout> layouts = new ArrayList<>();

    public static enum PageType {
        //连接
        CONCAT,
        //翻转
        TURN
    }
    /**
     * 页面布局
     */
    @Data
    public static class PageLayout {

        /**
         * 标识ID
         */
        private String identifier;

        //分页高度
        private Integer height;

        private Background background;

        private List<Element> elements;
    }
}
