package com.firefly.iview.util;

import com.firefly.iview.Element;
import com.firefly.iview.document.Document;
import com.firefly.iview.document.ImageDocument;
import com.firefly.iview.document.PageDocument;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class DocumentUtils {

    public static List<String> resolveTexts(Document document) {
        List<Element> elements = Collections.emptyList();
        if (document instanceof ImageDocument) {
            elements = ((ImageDocument) document).getElements();
        }
        if (document instanceof PageDocument) {
            elements = ((PageDocument) document).getElements();
        }
        return resolve(elements, element -> {
            Map<String, Object> properties = element.getProperties();
            if (properties == null) {
                return null;
            }
            return (String) properties.get("text");
        });
    }
    private static <T> List<T> resolve(List<Element> elements, Function<Element, T> function) {
        if (elements == null || elements.size() == 0) {
            return Collections.emptyList();
        }
        List<T> values = new ArrayList<>();
        for (Element element : elements) {
            T value = function.apply(element);
            if (value != null) {
                values.add(value);
            }
            List<Element> children = element.getChildren();
            values.addAll(resolve(children, function));
        }
        return values;
    }
}
