package com.firefly.iview;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.firefly.iview.document.Document;
import com.firefly.iview.document.Picture;
import lombok.Data;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;

@Data
public class Work {

//    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    private String id;


    /**
     * 区分资源
     */
//    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    private String namespace;

//    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    private String ownerId;

    //作品名称
    private String title;


    private String type;

    //封面，预览裁剪的
    private Picture cover;
    //预览
    private Picture preview;

    private Map<String, String> metadata = new HashMap<>();


    //文档类型
    private String doctype;

    //
    //300px x 300px
    //200mm x 200mm
    //微标
    //封面

    private Document document;

    private Instant updatedAt;
//    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    private Instant createdAt;

    public boolean owner(long uid) {
        return this.ownerId.equals(String.valueOf(uid));
    }
}
