package com.firefly.iview;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 元素
 */
@Data
public class Element {

    /**
     * 标识ID
     */
    private String identifier;

    /**
     * 基础元素
     * Group
     * Image
     * Text
     * Video
     * 等
     */
    private String as;

    /**
     * 组件名
     */
    private String title;

    /**
     * 属性
     */
    @JsonInclude()
    private Map<String, Object> properties;



    /**
     * 自定义的，便于扩展
     * 用于新方案的考量，后续完善后再从metadata内移除
     */
    @JsonInclude()
    private Map<String, String> metadata;


    /**
     * 可编辑扩展，不会运用于运行时
     * - enabledBinding: 元素 启用/禁止 绑定语法
     * - replaceable: 是否可替换
     * true 高亮提示可替换。默认
     * false 锁定。
     *
     */
    @JsonInclude()
    private Map<String, Object> editable;

    /**
     * 元素其他数据
     */
    @JsonIgnore
    private Map<String, Object> attributes = new HashMap<>();

    /**
     * 子节点
     */
    private List<Element> children;

    @JsonAnyGetter
    public Map<String, Object> other() {
        return this.attributes;
    }

    @JsonAnySetter
    public void setOther(String key, Object value) {
        this.attributes.put(key, value);
    }

}
