package com.firefly.iview.iapp;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 元素
 */
@Data
public class Element {

    /**
     * 标识ID
     */
    private String identifier;

    /**
     * 基础元素
     * Group
     * Image
     * Text
     * Video
     * 等
     */
    private String as;

    /**
     * 组件名
     */
    private String title;

    /**
     * 属性
     */
    private ElementProperties properties;

    /**
     * 语法-绑定当前的上下文： scope & behavior
     */
    @JsonInclude()
    private Map<String, String> bindings;

    /**
     * 语法-转为可执行函数
     */
    @JsonInclude()
    private Map<String, String> outputs;

    /**
     * 自定义的，便于扩展
     * 用于新方案的考量，后续完善后再从metadata内移除
     */
    @JsonInclude()
    private Map<String, String> metadata;


    /**
     * 可编辑扩展，不会运用于运行时
     * - enabledBinding: 元素 启用/禁止 绑定语法
     */
    @JsonInclude()
    private Map<String, Object> editable;

    /**
     * 元素其他数据
     */
    @JsonIgnore
    private Map<String, Object> attributes = new HashMap<>();

    /**
     * 子节点
     */
    private List<Element> children;

    @JsonAnyGetter
    public Map<String, Object> other() {
        return this.attributes;
    }

    @JsonAnySetter
    public void setOther(String key, Object value) {
        this.attributes.put(key, value);
    }

}
