package com.firefly.iview;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.firefly.iview.document.Document;
import com.firefly.iview.document.DocumentSchema;
import com.firefly.iview.document.Picture;
import lombok.Data;

import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Data
public class Template {

    private String id;

    private String namespace;

    private String title;

    //模板(文字模板，作品模板)
    private TemplateType type;

    private String description;

    private List<String> keywords;

    private Map<String, String> metadata = new HashMap<>();

    //封面
    private Picture cover;

    private Picture preview;

    private Document document;

    private Instant createdAt;
}
