package com.firefly.iview.document;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Data;

import java.util.List;


@JsonTypeInfo(
        use = JsonTypeInfo.Id.NAME,
        include = JsonTypeInfo.As.EXISTING_PROPERTY,
        property = "type",
        visible = true
)
@JsonSubTypes({
        @JsonSubTypes.Type(value = ElementDocument.class, name = "ELEMENT"),
        @JsonSubTypes.Type(value = ImageDocument.class, name = "IMAGE"),
        @JsonSubTypes.Type(value = PageDocument.class, name = "PAGE"),
})
@Data
public class Document {

//    private DocumentSchema schema;
    private String schema;

    private String type;

    //字体引用
    private List<FontFace> fonts;

    //图片素材资源引用
}
