package com.fireflly.iview.data;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;

import java.util.HashMap;
import java.util.Map;

@Data
public class ElementProperties {

    /**
     * 定位
     */
    private Position position;

    /**
     * 框架
     */
    private Frame frame;

    /**
     * 背景
     */
    private Background background;

    /**
     * 内边距
     */
    private EdgeInsets padding;

    /**
     * 外边距
     */
    private EdgeInsets margin;

    /**
     * 边框
     */
    private Border border;

    /**
     * 变换
     */
    private Transform transform;

    /**
     * 溢出
     */
    private Overflow overflow;

    /**
     * 样式
     */
    private CustomStyle customStyle;
    /**
     * 其他属性,
     * 组件衍生: 如Button onClick
     */
    @JsonIgnore
    private Map<String, Object> attributes = new HashMap<>();

    @JsonInclude()
    @JsonAnyGetter
    public Map<String, Object> other() {
        return this.attributes;
    }

    @JsonInclude()
    @JsonAnySetter
    public void setOther(String key, Object value) {
        this.attributes.put(key, value);
    }
}
