package com.firefly.iview.client;

import com.firefly.iview.*;
import com.firefly.iview.client.dto.ImageQueryInput;
import com.firefly.iview.client.dto.TemplateQueryInput;
import com.firefly.iview.client.dto.WorkQueryInput;
import org.beast.data.message.ReturnResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Nullable;
import java.util.List;

@FeignClient("firefly-iview")
public interface IViewClient {

    @GetMapping("/api/images/{id}")
    ReturnResult<Image> getImage(
            @PathVariable String id
    );

    @GetMapping("/api/images")
    ReturnResult<List<Image>> queryImagesBy(
            @SpringQueryMap ImageQueryInput input,
            Pageable pageable,
            @Nullable @RequestParam("after") String after
    );
    @GetMapping("/api/images/count")
    ReturnResult<Long> countImagesBy(
            @SpringQueryMap ImageQueryInput input
    );


    @GetMapping("/api/templates")
    ReturnResult<List<Template>> queryTemplatesBy(
            @SpringQueryMap TemplateQueryInput input
    );
    @GetMapping("/api/templates")
    ReturnResult<List<Template>> queryTemplatesBy(
            @SpringQueryMap TemplateQueryInput input,
            Pageable pageable,
            @Nullable @RequestParam("after") String after
    );

    @GetMapping("/api/templates/count")
    ReturnResult<Long> countTemplatesBy(
            @SpringQueryMap TemplateQueryInput input
    );

    @GetMapping("/api/templates/{id}")
    ReturnResult<Template> getTemplate(
            @PathVariable String id
    );

    @GetMapping("/api/works")
    ReturnResult<List<Work>> queryWorksBy(
            @SpringQueryMap WorkQueryInput input,
            Pageable pageable
    );
    @GetMapping("/api/works")
    ReturnResult<List<Work>> queryWorksBy(
         @SpringQueryMap WorkQueryInput input,
         Pageable pageable,
         @Nullable @RequestParam("after") String after
    );

    @GetMapping("/api/works/count")
    ReturnResult<Long> countWorksBy(
            @SpringQueryMap WorkQueryInput input
    );

    @PostMapping("/api/works")
    ReturnResult<Work> postWork(
            @RequestBody Work input
    );

    @GetMapping("/api/works/{id}")
    ReturnResult<Work> getWork(
            @PathVariable String id
    );

    @PutMapping("/api/works/{id}")
    ReturnResult<Work> putWork(
            @PathVariable String id,
            @RequestBody Work input
    );

    @PatchMapping("/api/works/{id}")
    ReturnResult<Work> patchWork(
            @PathVariable String id,
            @RequestBody Work input
    );

    @DeleteMapping("/api/works/{id}")
    ReturnResult<Work> removeWork(
            @PathVariable String id
    );

    @PostMapping("/api/works/{id}/release-page")
    ReturnResult<ReleasePage> releaseWorkPage(
            @PathVariable String id
    );
    @PostMapping("/api/works/{id}/share")
    ReturnResult<ReleasePage> shareWork(
            @PathVariable String id
    );

    @GetMapping("/api/release-pages/{id}")
    ReturnResult<ReleasePage> findReleasePageById(
            @PathVariable String id
    );

    @GetMapping("/api/shares/{id}")
    ReturnResult<Share> findShareById(
            @PathVariable String id
    );
}
